package com.siguiente.fasalexpert;

import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import androidx.databinding.DataBinderMapper;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.ViewDataBinding;
import com.siguiente.fasalexpert.databinding.ActiveMeetingItemDesignBindingImpl;
import com.siguiente.fasalexpert.databinding.ActivityLoginBindingImpl;
import com.siguiente.fasalexpert.databinding.ActivitySampleBindingImpl;
import com.siguiente.fasalexpert.databinding.ActivityTimeDateBindingImpl;
import com.siguiente.fasalexpert.databinding.ActivityViewQuestionBindingImpl;
import com.siguiente.fasalexpert.databinding.AnswerItemListDesignBindingImpl;
import com.siguiente.fasalexpert.databinding.AvailabilityTimeItemDesignBindingImpl;
import com.siguiente.fasalexpert.databinding.FragmentDashboardBindingImpl;
import com.siguiente.fasalexpert.databinding.FragmentHomeBindingImpl;
import com.siguiente.fasalexpert.databinding.FragmentNotificationsBindingImpl;
import com.siguiente.fasalexpert.databinding.NotificationItemDesignBindingImpl;
import com.siguiente.fasalexpert.databinding.SampleItemDesignBindingImpl;
import com.siguiente.fasalexpert.databinding.SampleItemDesignTwoBindingImpl;
import com.siguiente.fasalexpert.databinding.ScheduleMeetingItemDesignBindingImpl;
import com.siguiente.fasalexpert.databinding.ZoomImageBindingImpl;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataBinderMapperImpl extends DataBinderMapper {
  private static final int LAYOUT_ACTIVEMEETINGITEMDESIGN = 1;

  private static final int LAYOUT_ACTIVITYLOGIN = 2;

  private static final int LAYOUT_ACTIVITYSAMPLE = 3;

  private static final int LAYOUT_ACTIVITYTIMEDATE = 4;

  private static final int LAYOUT_ACTIVITYVIEWQUESTION = 5;

  private static final int LAYOUT_ANSWERITEMLISTDESIGN = 6;

  private static final int LAYOUT_AVAILABILITYTIMEITEMDESIGN = 7;

  private static final int LAYOUT_FRAGMENTDASHBOARD = 8;

  private static final int LAYOUT_FRAGMENTHOME = 9;

  private static final int LAYOUT_FRAGMENTNOTIFICATIONS = 10;

  private static final int LAYOUT_NOTIFICATIONITEMDESIGN = 11;

  private static final int LAYOUT_SAMPLEITEMDESIGN = 12;

  private static final int LAYOUT_SAMPLEITEMDESIGNTWO = 13;

  private static final int LAYOUT_SCHEDULEMEETINGITEMDESIGN = 14;

  private static final int LAYOUT_ZOOMIMAGE = 15;

  private static final SparseIntArray INTERNAL_LAYOUT_ID_LOOKUP = new SparseIntArray(15);

  static {
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.active_meeting_item_design, LAYOUT_ACTIVEMEETINGITEMDESIGN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.activity_login, LAYOUT_ACTIVITYLOGIN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.activity_sample, LAYOUT_ACTIVITYSAMPLE);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.activity_time_date, LAYOUT_ACTIVITYTIMEDATE);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.activity_view_question, LAYOUT_ACTIVITYVIEWQUESTION);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.answer_item_list_design, LAYOUT_ANSWERITEMLISTDESIGN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.availability_time_item_design, LAYOUT_AVAILABILITYTIMEITEMDESIGN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.fragment_dashboard, LAYOUT_FRAGMENTDASHBOARD);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.fragment_home, LAYOUT_FRAGMENTHOME);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.fragment_notifications, LAYOUT_FRAGMENTNOTIFICATIONS);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.notification_item_design, LAYOUT_NOTIFICATIONITEMDESIGN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.sample_item_design, LAYOUT_SAMPLEITEMDESIGN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.sample_item_design_two, LAYOUT_SAMPLEITEMDESIGNTWO);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.schedule_meeting_item_design, LAYOUT_SCHEDULEMEETINGITEMDESIGN);
    INTERNAL_LAYOUT_ID_LOOKUP.put(com.siguiente.fasalexpert.R.layout.zoom_image, LAYOUT_ZOOMIMAGE);
  }

  @Override
  public ViewDataBinding getDataBinder(DataBindingComponent component, View view, int layoutId) {
    int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
    if(localizedLayoutId > 0) {
      final Object tag = view.getTag();
      if(tag == null) {
        throw new RuntimeException("view must have a tag");
      }
      switch(localizedLayoutId) {
        case  LAYOUT_ACTIVEMEETINGITEMDESIGN: {
          if ("layout/active_meeting_item_design_0".equals(tag)) {
            return new ActiveMeetingItemDesignBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for active_meeting_item_design is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYLOGIN: {
          if ("layout/activity_login_0".equals(tag)) {
            return new ActivityLoginBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_login is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYSAMPLE: {
          if ("layout/activity_sample_0".equals(tag)) {
            return new ActivitySampleBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_sample is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYTIMEDATE: {
          if ("layout/activity_time_date_0".equals(tag)) {
            return new ActivityTimeDateBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_time_date is invalid. Received: " + tag);
        }
        case  LAYOUT_ACTIVITYVIEWQUESTION: {
          if ("layout/activity_view_question_0".equals(tag)) {
            return new ActivityViewQuestionBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for activity_view_question is invalid. Received: " + tag);
        }
        case  LAYOUT_ANSWERITEMLISTDESIGN: {
          if ("layout/answer_item_list_design_0".equals(tag)) {
            return new AnswerItemListDesignBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for answer_item_list_design is invalid. Received: " + tag);
        }
        case  LAYOUT_AVAILABILITYTIMEITEMDESIGN: {
          if ("layout/availability_time_item_design_0".equals(tag)) {
            return new AvailabilityTimeItemDesignBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for availability_time_item_design is invalid. Received: " + tag);
        }
        case  LAYOUT_FRAGMENTDASHBOARD: {
          if ("layout/fragment_dashboard_0".equals(tag)) {
            return new FragmentDashboardBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for fragment_dashboard is invalid. Received: " + tag);
        }
        case  LAYOUT_FRAGMENTHOME: {
          if ("layout/fragment_home_0".equals(tag)) {
            return new FragmentHomeBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for fragment_home is invalid. Received: " + tag);
        }
        case  LAYOUT_FRAGMENTNOTIFICATIONS: {
          if ("layout/fragment_notifications_0".equals(tag)) {
            return new FragmentNotificationsBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for fragment_notifications is invalid. Received: " + tag);
        }
        case  LAYOUT_NOTIFICATIONITEMDESIGN: {
          if ("layout/notification_item_design_0".equals(tag)) {
            return new NotificationItemDesignBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for notification_item_design is invalid. Received: " + tag);
        }
        case  LAYOUT_SAMPLEITEMDESIGN: {
          if ("layout/sample_item_design_0".equals(tag)) {
            return new SampleItemDesignBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for sample_item_design is invalid. Received: " + tag);
        }
        case  LAYOUT_SAMPLEITEMDESIGNTWO: {
          if ("layout/sample_item_design_two_0".equals(tag)) {
            return new SampleItemDesignTwoBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for sample_item_design_two is invalid. Received: " + tag);
        }
        case  LAYOUT_SCHEDULEMEETINGITEMDESIGN: {
          if ("layout/schedule_meeting_item_design_0".equals(tag)) {
            return new ScheduleMeetingItemDesignBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for schedule_meeting_item_design is invalid. Received: " + tag);
        }
        case  LAYOUT_ZOOMIMAGE: {
          if ("layout/zoom_image_0".equals(tag)) {
            return new ZoomImageBindingImpl(component, view);
          }
          throw new IllegalArgumentException("The tag for zoom_image is invalid. Received: " + tag);
        }
      }
    }
    return null;
  }

  @Override
  public ViewDataBinding getDataBinder(DataBindingComponent component, View[] views, int layoutId) {
    if(views == null || views.length == 0) {
      return null;
    }
    int localizedLayoutId = INTERNAL_LAYOUT_ID_LOOKUP.get(layoutId);
    if(localizedLayoutId > 0) {
      final Object tag = views[0].getTag();
      if(tag == null) {
        throw new RuntimeException("view must have a tag");
      }
      switch(localizedLayoutId) {
      }
    }
    return null;
  }

  @Override
  public int getLayoutId(String tag) {
    if (tag == null) {
      return 0;
    }
    Integer tmpVal = InnerLayoutIdLookup.sKeys.get(tag);
    return tmpVal == null ? 0 : tmpVal;
  }

  @Override
  public String convertBrIdToString(int localId) {
    String tmpVal = InnerBrLookup.sKeys.get(localId);
    return tmpVal;
  }

  @Override
  public List<DataBinderMapper> collectDependencies() {
    ArrayList<DataBinderMapper> result = new ArrayList<DataBinderMapper>(1);
    result.add(new androidx.databinding.library.baseAdapters.DataBinderMapperImpl());
    return result;
  }

  private static class InnerBrLookup {
    static final SparseArray<String> sKeys = new SparseArray<String>(6);

    static {
      sKeys.put(0, "_all");
      sKeys.put(1, "activeScheduleModel");
      sKeys.put(2, "answerModel");
      sKeys.put(3, "availabilityModel");
      sKeys.put(4, "notificationModel");
      sKeys.put(5, "viewQuestionModel");
    }
  }

  private static class InnerLayoutIdLookup {
    static final HashMap<String, Integer> sKeys = new HashMap<String, Integer>(15);

    static {
      sKeys.put("layout/active_meeting_item_design_0", com.siguiente.fasalexpert.R.layout.active_meeting_item_design);
      sKeys.put("layout/activity_login_0", com.siguiente.fasalexpert.R.layout.activity_login);
      sKeys.put("layout/activity_sample_0", com.siguiente.fasalexpert.R.layout.activity_sample);
      sKeys.put("layout/activity_time_date_0", com.siguiente.fasalexpert.R.layout.activity_time_date);
      sKeys.put("layout/activity_view_question_0", com.siguiente.fasalexpert.R.layout.activity_view_question);
      sKeys.put("layout/answer_item_list_design_0", com.siguiente.fasalexpert.R.layout.answer_item_list_design);
      sKeys.put("layout/availability_time_item_design_0", com.siguiente.fasalexpert.R.layout.availability_time_item_design);
      sKeys.put("layout/fragment_dashboard_0", com.siguiente.fasalexpert.R.layout.fragment_dashboard);
      sKeys.put("layout/fragment_home_0", com.siguiente.fasalexpert.R.layout.fragment_home);
      sKeys.put("layout/fragment_notifications_0", com.siguiente.fasalexpert.R.layout.fragment_notifications);
      sKeys.put("layout/notification_item_design_0", com.siguiente.fasalexpert.R.layout.notification_item_design);
      sKeys.put("layout/sample_item_design_0", com.siguiente.fasalexpert.R.layout.sample_item_design);
      sKeys.put("layout/sample_item_design_two_0", com.siguiente.fasalexpert.R.layout.sample_item_design_two);
      sKeys.put("layout/schedule_meeting_item_design_0", com.siguiente.fasalexpert.R.layout.schedule_meeting_item_design);
      sKeys.put("layout/zoom_image_0", com.siguiente.fasalexpert.R.layout.zoom_image);
    }
  }
}
