package com.siguiente.fasalexpert.network

import com.siguiente.fasalexpert.network.response.*
import okhttp3.OkHttpClient
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.*

@JvmSuppressWildcards
interface MyApi {

    @POST("login.php")
    suspend fun userLogin(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("expertSchedule.php")
    suspend fun addAvailability(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("getExpertScheduleList.php")
    suspend fun getExpertAvailabilityList(@Body fieldName: Map<String, String>): Response<AvailabilityListResponse>

    @POST("expertScheduleDelete.php")
    suspend fun deleteAvailability(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("scheduleActiveDeactive.php")
    suspend fun changeAvailabilityStatus(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("getExpertScheduleNotificationList.php")
    suspend fun getNotificationList(@Body fieldName: Map<String, String>): Response<NotificationResponse>

    @POST("notificationAcceptReject.php")
    suspend fun changeNotificationStatus(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("getExpertActiveScheduleList.php")
    suspend fun getActiveScheduleList(@Body fieldName: Map<String, String>): Response<ActiveScheduleResponse>


    @POST("changeActiveScheduleStatus.php")
    suspend fun changeActiveScheduleStatus(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("viewServiceRequestDetail.php")
    suspend fun viewServiceRequestDetail(@Body fieldName: Map<String, String>): Response<ViewQuestionResponse>


    @POST("addServiceRequestReply.php")
    suspend fun addServiceRequestReply(@Body fieldName: Map<String, String>): Response<AnswerResponse>

    @POST("getServiceRequestReply.php")
    suspend fun getServiceRequestReply(@Body fieldName: Map<String, String>): Response<AnswerResponse>

    @POST("serviceRequestReplyDelete.php")
    suspend fun deleteAnswer(@Body fieldName: Map<String, String>): Response<CommonResponse>

    @POST("makeCall.php")
    suspend fun makeCall(@Body fieldName: Map<String, String>): Response<CommonResponse>



    companion object {
        operator fun invoke(
            networkConnectionInterceptor: NetworkConnectionInterceptor
        ): MyApi {

            val okkHttpclient = OkHttpClient.Builder()
                .addInterceptor(networkConnectionInterceptor)
                .build()

            return Retrofit.Builder()
                .client(okkHttpclient)
                .baseUrl("https://siguientesoft.com/kishan/api/user/")
                .addConverterFactory(GsonConverterFactory.create())
                .build()
                .create(MyApi::class.java)
        }
    }

}

