package com.siguiente.fasalexpert.network

import com.siguiente.fasalexpert.network.response.*

class Repository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun login(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.userLogin(filed)
        }
    }

    suspend fun addAvailability(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.addAvailability(filed)
        }
    }

    suspend fun getExpertAvailabilityList(filed: Map<String, String>): AvailabilityListResponse {
        return apiRequest {
            api.getExpertAvailabilityList(filed)
        }
    }

    suspend fun deleteAvailability(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.deleteAvailability(filed)
        }
    }

    suspend fun changeAvailabilityStatus(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.changeAvailabilityStatus(filed)
        }
    }

    suspend fun getNotificationList(filed: Map<String, String>): NotificationResponse {
        return apiRequest {
            api.getNotificationList(filed)
        }
    }

    suspend fun changeNotificationStatus(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.changeNotificationStatus(filed)
        }
    }

    suspend fun getActiveScheduleList(filed: Map<String, String>): ActiveScheduleResponse {
        return apiRequest {
            api.getActiveScheduleList(filed)
        }
    }

    suspend fun changeActiveScheduleStatus(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.changeActiveScheduleStatus(filed)
        }
    }

    suspend fun viewQuestion(filed: Map<String, String>): ViewQuestionResponse {
        return apiRequest {
            api.viewServiceRequestDetail(filed)
        }
    }

    suspend fun addServiceRequestReply(filed: Map<String, String>): AnswerResponse {
        return apiRequest {
            api.addServiceRequestReply(filed)
        }
    }

    suspend fun getServiceRequestReply(filed: Map<String, String>): AnswerResponse {
        return apiRequest {
            api.getServiceRequestReply(filed)
        }
    }

    suspend fun deleteAnswer(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.deleteAnswer(filed)
        }
    }

    suspend fun makeCall(filed: Map<String, String>): CommonResponse {
        return apiRequest {
            api.makeCall(filed)
        }
    }
}
