package com.siguiente.fasalexpert.ui.activity

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.login.ui.login.LoginViewModel
import com.siguiente.fasal.login.ui.login.LoginViewModelFactory
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.ActivityLoginBinding
import com.siguiente.fasalexpert.utility.PreferenceProvider
import com.siguiente.fasalexpert.utils.toast
import kotlinx.android.synthetic.main.activity_login.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class LoginActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()
    private lateinit var loginViewModel: LoginViewModel
    private lateinit var binding: ActivityLoginBinding
    val factory: LoginViewModelFactory by instance()
    val provider: PreferenceProvider by instance()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
      /*  val isLogin = provider.getValueByKey("isLogin")
        if (isLogin == "Y"){
            startActivity(Intent(this,MainActivity::class.java))
        }*/
        binding = DataBindingUtil.setContentView(this, R.layout.activity_login)
        supportActionBar?.hide()

        loginViewModel = ViewModelProvider(this, factory)
            .get(LoginViewModel::class.java)

        loginViewModel.loginResult.observe(this@LoginActivity, Observer {
            loginProgressBar.visibility = View.GONE
            if (!it.error) {
                provider.saveValueByKey("expertID", it.userID.toString())
                provider.saveValueByKey("userType", "" + it.userType)
                provider.saveValueByKey("isLogin", "Y")
                val intent = Intent(applicationContext, MainActivity::class.java)
                intent.putExtra("ActivityTag", "Login")
                startActivity(intent)
                this.finish()
            } else {
                toast("" + it.message)
            }
        })

        binding.login.setOnClickListener {
            if (!username.text.isNullOrEmpty() && !password.text.isNullOrEmpty()) {
                loginProgressBar.visibility = View.VISIBLE
                userLogin()
            } else {
                toast("Field Empty")
            }
        }

    }

    override fun onStart() {
        super.onStart()
    }

    private fun userLogin() {
        val token = provider.getValueByKey("firebaseToken")
        val mobile = binding.username.text.toString().trim()
        val password = binding.password.text.toString().trim()
        val map: HashMap<String, String> = HashMap()
        map["userMobile"] = mobile
        map["userPassword"] = password
        map["firebaseToken"] = token.toString()
        loginViewModel.login(map)
    }
}