package com.siguiente.fasal.login.ui.login

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasalexpert.network.Repository
import com.siguiente.fasalexpert.network.response.CommonResponse
import com.siguiente.fasalexpert.utils.ApiException
import com.siguiente.fasalexpert.utils.Coroutines
import com.siguiente.fasalexpert.utils.NoInternetException


class LoginViewModel(private val repository: Repository) : ViewModel() {

     val loginResult = MutableLiveData<CommonResponse>()

    //For Verifying OTP
    fun login(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.login(field)
                loginResult.value = response
                Log.e("LoginResult",""+response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}