package com.siguiente.fasalexpert.ui.activity

import android.os.Build
import android.os.Bundle
import android.view.MenuItem
import android.widget.TimePicker
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.chip.Chip
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.ActivityTimeDateBinding
import com.siguiente.fasalexpert.ui.settings.SettingViewModel
import com.siguiente.fasalexpert.ui.settings.SettingViewModelFactory
import com.siguiente.fasalexpert.utility.PreferenceProvider
import com.siguiente.fasalexpert.utils.toast
import kotlinx.android.synthetic.main.activity_time_date.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap

class TimeDateActivity : AppCompatActivity(), KodeinAware, TimePicker.OnTimeChangedListener {
    lateinit var binding: ActivityTimeDateBinding
    override val kodein by kodein()
    private lateinit var settingViewModel: SettingViewModel
    private val settingFactory: SettingViewModelFactory by instance()
    private val provider: PreferenceProvider by instance()

    var startTime = ""
    var endTime = ""
    var days = ""

    @RequiresApi(Build.VERSION_CODES.M)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_time_date)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        settingViewModel = ViewModelProvider(this, settingFactory).get(SettingViewModel::class.java)

        settingViewModel.addAvailabilityResult.observe(this, Observer {
            if (!it.error) {
              showConfirmationMessage(it.message)
            }
        })

        startTimePicker.setOnTimeChangedListener(this)
        endTimePicker.setOnTimeChangedListener(this)


        val list = mutableListOf<String>()
        for (index in 0 until daysChipGroup.childCount) {
            val chip: Chip = daysChipGroup.getChildAt(index) as Chip
            chip.setOnCheckedChangeListener { view, isChecked ->
                if (isChecked) {
                    list.add(view.text.toString())
                } else {
                    list.remove(view.text.toString())
                }

            }
        }

        saveDateTimeButton.setOnClickListener {
            days = if (list.size == 7) "Everyday" else list.toString().replace("[", "")
                .replace("]", "")

            var error = false

            if (days.isEmpty()) {
                error = true
                toast("Select days")
            }

            if (startTime.isEmpty()) {
                error = true
                toast("Select start time")
            }
            if (endTime.isEmpty()) {
                error = true
                toast("Select end time")
            }


            if (!error)
                addAvailability()

        }

    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                true
            }

            else -> super.onOptionsItemSelected(item)
        }
    }

    override fun onTimeChanged(view: TimePicker?, hourOfDay: Int, minute: Int) {
        when (view?.id) {
            R.id.startTimePicker -> {
                startTime = timeSelector(hourOfDay, minute)
            }
            R.id.endTimePicker -> {
                endTime = timeSelector(hourOfDay, minute)
            }
        }
    }

    private fun timeSelector(hourOfDay: Int, minute: Int): String {
        var hour = hourOfDay
        var ampm = ""
        when {
            hour == 0 -> {
                hour += 12
                ampm = "AM"
            }
            hour == 12 -> ampm = "PM"
            hour > 12 -> {
                hour -= 12
                ampm = "PM"
            }
            else -> ampm = "AM"
        }

        val hours = if (hour < 10) "0$hour" else hour
        val min = if (minute < 10) "0$minute" else minute
        return "$hours:$min $ampm"
    }


    private fun addAvailability() {
        val map: HashMap<String, String> = HashMap()
        val expertID = provider.getValueByKey("expertID")
        map["expertID"] = expertID!!
        map["startTime"] = startTime
        map["endTime"] = endTime
        map["scheduleDay"] = days
        settingViewModel.addAvailability(map)
    }

    private fun showConfirmationMessage(message: String) {
        val builder = AlertDialog.Builder(this)
        builder.setMessage(message)
        builder.setPositiveButton("Close") { dialogInterface, _ ->
            this.finish()
            dialogInterface.dismiss()

        }
        val alertDialog: AlertDialog = builder.create()
        alertDialog.setCancelable(false)
        alertDialog.show()
    }

}