package com.siguiente.fasalexpert.ui.activity


import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.MenuItem
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.ActivityViewQuestionBinding
import com.siguiente.fasalexpert.network.response.ViewQuestionResponse
import com.siguiente.fasalexpert.ui.adapter.AnswerAdapter
import com.siguiente.fasalexpert.ui.dialog.ZoomImageDialog
import com.siguiente.fasalexpert.ui.model.AnswerModel
import kotlinx.android.synthetic.main.activity_view_question.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance
import java.util.HashMap


class ViewQuestionActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()

    private val factory: ViewQuestionViewModelFactory by instance()
    lateinit var viewModel: ViewQuestionViewModel
    lateinit var binding: ActivityViewQuestionBinding
    lateinit var responseModel: ViewQuestionResponse

    private var serviceRequestID = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_view_question)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        serviceRequestID = intent.extras!!.getString("serviceRequestID", "")
        viewModel = ViewModelProvider(this, factory).get(ViewQuestionViewModel::class.java)
        viewQuestion()
        getAnswer()


        viewModel.viewQuestionResult.observe(this, Observer {
            if (!it.error!!) {
                binding.viewQuestionModel = it
                responseModel = it
            }
        })

        viewModel.addServiceRequestReplyResult.observe(this, Observer {
            if (!it.error!!) {
                initAnswerRecyclerView(it.data!!)
            }
        })

        viewModel.viewServiceRequestReplyResult.observe(this, Observer {
            if (!it.error!!) {
                initAnswerRecyclerView(it.data!!)
            } else {
                answerRecyclerView.apply {
                    adapter = null
                }
            }
        })

        viewModel.deleteAnswerResult.observe(this, Observer {
            if (!it.error) {
                getAnswer()
            }
        })

        submitAnswerButton.setOnClickListener {
            addServiceRequestReply()
        }

        questionImage1TV.setOnClickListener {
            if (responseModel.imageOne != null)
                showDialog(responseModel.imageOne!!)
        }
        questionImage2TV.setOnClickListener {
            if (responseModel.imageTwo != null)
                showDialog(responseModel.imageTwo!!)
        }
        questionImage3TV.setOnClickListener {
            if (responseModel.imageThree != null)
                showDialog(responseModel.imageThree!!)
        }
        questionImage4TV.setOnClickListener {
            if (responseModel.imageFour != null)
                showDialog(responseModel.imageFour!!)
        }

    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return when (item.itemId) {
            android.R.id.home -> {
                onBackPressed()
                true
            }

            else -> super.onOptionsItemSelected(item)
        }
    }


    private fun initAnswerRecyclerView(arrayList: ArrayList<AnswerModel>) {
        val answerAdapter = AnswerAdapter().apply {
            addItems(arrayList)
        }
        answerRecyclerView.apply {
            adapter = answerAdapter
        }

        answerAdapter.listener = { view, item, position ->
            deleteAnswer(item.id!!)
        }

    }

    private fun showDialog(url: String) {
        val dialog = ZoomImageDialog(url)
        dialog.show(supportFragmentManager, "ZoomImage")
    }

    private fun viewQuestion() {
        val map: HashMap<String, String> = HashMap()
        map["serviceRequestID"] = serviceRequestID
        viewModel.viewQuestion(map)
    }

    private fun deleteAnswer(replyID: String) {
        val map: HashMap<String, String> = HashMap()
        map["replyID"] = replyID
        viewModel.deleteAnswer(map)
    }

    private fun getAnswer() {
        val map: HashMap<String, String> = HashMap()
        map["serviceRequestID"] = serviceRequestID
        viewModel.viewServiceRequestReply(map)
    }

    private fun addServiceRequestReply() {
        when {
            answerTitle.text!!.isEmpty() -> answerTitle.error = "Enter Title"
            answerDescription.text!!.isEmpty() -> answerDescription.error = "Enter Description"
            else -> {

                val map: HashMap<String, String> = HashMap()
                map["serviceRequestID"] = serviceRequestID
                map["title"] = answerTitle.text.toString()
                map["description"] = answerDescription.text.toString()
                viewModel.addServiceRequestReply(map)

                answerTitle.setText("")
                answerDescription.setText("")
            }
        }
    }
}