package com.siguiente.fasalexpert.ui.activity

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasalexpert.network.Repository
import com.siguiente.fasalexpert.network.response.AnswerResponse
import com.siguiente.fasalexpert.network.response.CommonResponse
import com.siguiente.fasalexpert.network.response.ViewQuestionResponse
import com.siguiente.fasalexpert.utils.ApiException
import com.siguiente.fasalexpert.utils.Coroutines
import com.siguiente.fasalexpert.utils.NoInternetException

class ViewQuestionViewModel(
    private val repository: Repository
) : ViewModel() {

    val viewQuestionResult = MutableLiveData<ViewQuestionResponse>()
    val addServiceRequestReplyResult = MutableLiveData<AnswerResponse>()
    val viewServiceRequestReplyResult = MutableLiveData<AnswerResponse>()
    val deleteAnswerResult = MutableLiveData<CommonResponse>()

    fun viewQuestion(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.viewQuestion(field)
                viewQuestionResult.value = response
                Log.e("viewQuestionResult", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun addServiceRequestReply(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.addServiceRequestReply(field)
                addServiceRequestReplyResult.value = response
                Log.e("addServiceRequestReply", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun viewServiceRequestReply(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getServiceRequestReply(field)
                viewServiceRequestReplyResult.value = response
                Log.e("viewServRequestReResult", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun deleteAnswer(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.deleteAnswer(field)
                deleteAnswerResult.value = response
                Log.e("deleteAnswer", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}