package com.siguiente.fasalexpert.ui.adapter


import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.ActiveMeetingItemDesignBinding
import com.siguiente.fasalexpert.ui.model.ActiveScheduleModel
import com.siguiente.fasalexpert.utility.BaseRecyclerViewAdapter

class ActiveMeetingAdapter :
    BaseRecyclerViewAdapter<ActiveScheduleModel, ActiveMeetingItemDesignBinding>() {
    override fun getLayout() = R.layout.active_meeting_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<ActiveMeetingItemDesignBinding>,
        position: Int
    ) {
        holder.binding.activeScheduleModel = items[position]
        holder.binding.callLinearLayout.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

        holder.binding.viewLinearLayout.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}