package com.siguiente.fasalexpert.ui.adapter

import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.AnswerItemListDesignBinding
import com.siguiente.fasalexpert.ui.model.AnswerModel
import com.siguiente.fasalexpert.utility.BaseRecyclerViewAdapter

class AnswerAdapter :
    BaseRecyclerViewAdapter<AnswerModel, AnswerItemListDesignBinding>() {
    override fun getLayout() = R.layout.answer_item_list_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<AnswerItemListDesignBinding>,
        position: Int
    ) {
        holder.binding.answerModel = items[position]
        holder.binding.deleteAnswerIV.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }
    }

}