package com.siguiente.fasalexpert.ui.adapter

import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.AvailabilityTimeItemDesignBinding
import com.siguiente.fasalexpert.ui.model.AvailabilityModel
import com.siguiente.fasalexpert.utility.BaseRecyclerViewAdapter

class AvailabilityAdapter :
    BaseRecyclerViewAdapter<AvailabilityModel, AvailabilityTimeItemDesignBinding>() {
    override fun getLayout() = R.layout.availability_time_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<AvailabilityTimeItemDesignBinding>,
        position: Int
    ) {
        holder.binding.availabilityModel = items[position]
        holder.binding.cancelAvailabilityIV.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

        holder.binding.availabilitySwitch.setOnCheckedChangeListener { buttonView, isChecked ->
            if (buttonView.isPressed)
                listener?.invoke(buttonView, items[position], position)
        }

    }

}