package com.siguiente.fasalexpert.ui.adapter

import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.NotificationItemDesignBinding
import com.siguiente.fasalexpert.ui.model.NotificationModel
import com.siguiente.fasalexpert.utility.BaseRecyclerViewAdapter

class NotificationAdapter :
    BaseRecyclerViewAdapter<NotificationModel, NotificationItemDesignBinding>() {
    override fun getLayout() = R.layout.notification_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<NotificationItemDesignBinding>,
        position: Int
    ) {
        holder.binding.notificationModel = items[position]
        holder.binding.acceptTV.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

        holder.binding.rejectTV.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}