package com.siguiente.fasalexpert.ui.dialog

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.DialogFragment
import com.bumptech.glide.Glide
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.ZoomImageBinding
import kotlinx.android.synthetic.main.zoom_image.*

class ZoomImageDialog(val imageUrl:String) : DialogFragment() {
    lateinit var binding: ZoomImageBinding
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(
            inflater,
            R.layout.zoom_image,
            container,
            false
        )

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        val url = resources.getString(R.string.queryImageUrl)
        Glide.with(zoomImageTV).load(url+imageUrl).into(zoomImageTV)

    }
}