package com.siguiente.fasalexpert.ui.home

import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.FragmentHomeBinding
import com.siguiente.fasalexpert.ui.activity.VideoChatViewActivity
import com.siguiente.fasalexpert.ui.activity.ViewQuestionActivity
import com.siguiente.fasalexpert.ui.adapter.ActiveMeetingAdapter
import com.siguiente.fasalexpert.ui.model.ActiveScheduleModel
import com.siguiente.fasalexpert.utility.PreferenceProvider
import kotlinx.android.synthetic.main.fragment_home.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class HomeFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    private lateinit var homeViewModel: HomeViewModel
    lateinit var binding: FragmentHomeBinding
    private val provider: PreferenceProvider by instance()
    private val viewModelFactory: HomeViewModelFactory by instance()
    var token = ""
    var callerName = ""

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_home, container, false)


        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        homeViewModel = ViewModelProvider(this, viewModelFactory).get(HomeViewModel::class.java)
        getActiveScheduleList()
        homeViewModel.activeScheduleListResult.observe(viewLifecycleOwner, Observer {
            if (!it.error!!) {
                initActiveMeetingRV(it.data!!)
            }
        })

        homeViewModel.callingResult.observe(viewLifecycleOwner, Observer {
            if (!it.error) {
                val intent = Intent(context, VideoChatViewActivity::class.java)
                intent.putExtra("agoraToken", "" + token)
                intent.putExtra("callerName", "" + callerName)
                startActivity(intent)
            }
        })


    }


    private fun getActiveScheduleList() {
        val expertID = provider.getValueByKey("expertID")!!
        val map = HashMap<String, String>()
        map["expertID"] = expertID
        homeViewModel.getActiveScheduleList(map)

    }

    private fun makeCall(userID: String) {
        val expertID = provider.getValueByKey("expertID")!!
        val map = HashMap<String, String>()
        map["expertID"] = expertID
        map["userID"] = userID
        map["callingToken"] = token
        homeViewModel.makeCall(map)

    }

    private fun initActiveMeetingRV(arrayList: ArrayList<ActiveScheduleModel>) {
        val activeAdapter = ActiveMeetingAdapter().apply {
            addItems(arrayList)
        }
        activeMeetingRV.apply {
            adapter = activeAdapter
        }
        activeAdapter.listener = { view, item, position ->
            if (view.tag.toString() == "VideoCall") {
                token = item.token
                callerName = item.userName
                makeCall(item.userID)
            } else {
                val intent = Intent(context, ViewQuestionActivity::class.java)
                intent.putExtra("serviceRequestID", item.serviceRequestID)
                startActivity(intent)
            }
        }

    }

    /*fun initAllMeetingRV() {
        val scheduleAdapter = ScheduledMeetingAdapter().apply {
            addItems(arraylist)
        }
        allMeetingRV.apply {
            adapter = scheduleAdapter
        }
    }*/
}