package com.siguiente.fasalexpert.ui.home

import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasalexpert.network.Repository
import com.siguiente.fasalexpert.network.response.ActiveScheduleResponse
import com.siguiente.fasalexpert.network.response.CommonResponse
import com.siguiente.fasalexpert.network.response.NotificationResponse
import com.siguiente.fasalexpert.utils.ApiException
import com.siguiente.fasalexpert.utils.Coroutines
import com.siguiente.fasalexpert.utils.NoInternetException

class HomeViewModel(
    private val repository: Repository
) : ViewModel() {

    var activeScheduleListResult = MutableLiveData<ActiveScheduleResponse>()
    var notificationStatusResult = MutableLiveData<CommonResponse>()
    var callingResult = MutableLiveData<CommonResponse>()

    fun getActiveScheduleList(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getActiveScheduleList(field)
                activeScheduleListResult.value = response
                Log.i("activeScheduleList", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun makeCall(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.makeCall(field)
                callingResult.value = response
                Log.i("Calling result", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun changeActiveScheduleStatus(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.changeNotificationStatus(field)
                notificationStatusResult.value = response
                Log.e("changeActiveSchedule", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun changeNotificationStatus(notificationID: String, status: String) {
        val map = HashMap<String, String>()
        map["notificationID"] = notificationID
        map["status"] = status

    }


}