package com.siguiente.fasalexpert.ui.notifications

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.app.AlertDialog
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.FragmentNotificationsBinding
import com.siguiente.fasalexpert.ui.adapter.NotificationAdapter
import com.siguiente.fasalexpert.ui.model.NotificationModel
import com.siguiente.fasalexpert.utility.PreferenceProvider
import kotlinx.android.synthetic.main.fragment_notifications.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class NotificationsFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    private lateinit var notificationsViewModel: NotificationsViewModel
    private val factory: NotificationViewModelFactory by instance()
    lateinit var binding: FragmentNotificationsBinding
    private val provider: PreferenceProvider by instance()

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {

        binding =
            DataBindingUtil.inflate(inflater, R.layout.fragment_notifications, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        notificationsViewModel =
            ViewModelProvider(this, factory).get(NotificationsViewModel::class.java)
        getNotificationList()
        notificationsViewModel.notificationResult.observe(viewLifecycleOwner, Observer {
            if (!it.error!!) {
                initNotificationRV(it.data!!)
            }else{
                notificationRV.adapter = null
            }
        })

        notificationsViewModel.notificationStatusResult.observe(viewLifecycleOwner, Observer {
            if (!it.error) {
                getNotificationList()
            }
        })
    }

    private fun getNotificationList() {
        val expertID = provider.getValueByKey("expertID")!!
        val map = HashMap<String, String>()
        map["expertID"] = expertID
        notificationsViewModel.getNotificationList(map)

    }

    private fun initNotificationRV(arrayList: ArrayList<NotificationModel>) {

        val notificationAdapter = NotificationAdapter().apply {
            addItems(arrayList)
        }
        notificationRV.apply {
            adapter = notificationAdapter
        }

        notificationAdapter.listener = { view, item, _ ->
            if (view.tag.toString() == "Accept")
                showConfirmationMessage(
                    item.id,
                    "1",
                    item.serviceRequestID,
                    "Are you sure you want to accept?"
                )
            else
                showConfirmationMessage(
                    item.id,
                    "2",
                    item.serviceRequestID,
                    "Are you sure you want to reject?"
                )
        }
    }


    private fun showConfirmationMessage(
        notificationID: String,
        status: String,
        serviceRequestID: String,
        message: String
    ) {
        val builder = AlertDialog.Builder(requireContext())
        builder.setMessage(message)
        builder.setPositiveButton("Yes") { dialogInterface, _ ->
            notificationsViewModel.changeNotificationStatus(
                notificationID,
                status,
                serviceRequestID
            )
            dialogInterface.dismiss()

        }
        builder.setNegativeButton("No") { dialogInterface, _ ->
            dialogInterface.dismiss()
        }
        val alertDialog: AlertDialog = builder.create()
        alertDialog.setCancelable(false)
        alertDialog.show()
    }

}