package com.siguiente.fasalexpert.ui.notifications

import android.util.Log
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasalexpert.network.Repository
import com.siguiente.fasalexpert.network.response.AvailabilityListResponse
import com.siguiente.fasalexpert.network.response.CommonResponse
import com.siguiente.fasalexpert.network.response.NotificationResponse
import com.siguiente.fasalexpert.utils.ApiException
import com.siguiente.fasalexpert.utils.Coroutines
import com.siguiente.fasalexpert.utils.NoInternetException

class NotificationsViewModel(
    private val repository: Repository
) : ViewModel() {

    var notificationResult = MutableLiveData<NotificationResponse>()
    var notificationStatusResult = MutableLiveData<CommonResponse>()

    fun getNotificationList(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getNotificationList(field)
                notificationResult.value = response
                Log.i("getNotificationList", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    private fun changeNotificationStatus(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.changeNotificationStatus(field)
                notificationStatusResult.value = response
                Log.e("changeNotificationS", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun changeNotificationStatus(notificationID: String, status: String,serviceRequestID:String) {
        val map = HashMap<String, String>()
        map["notificationID"] = notificationID
        map["status"] = status
        map["serviceRequestID"] = serviceRequestID
        changeNotificationStatus(map)
    }


}