package com.siguiente.fasalexpert.ui.settings

import android.content.Intent
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.appcompat.app.AlertDialog
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.switchmaterial.SwitchMaterial
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.databinding.FragmentDashboardBinding
import com.siguiente.fasalexpert.ui.activity.TimeDateActivity
import com.siguiente.fasalexpert.ui.adapter.AvailabilityAdapter
import com.siguiente.fasalexpert.ui.model.AvailabilityModel
import com.siguiente.fasalexpert.utility.PreferenceProvider
import kotlinx.android.synthetic.main.fragment_dashboard.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class SettingFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    private lateinit var dashboardViewModel: SettingViewModel
    private val settingFactory: SettingViewModelFactory by instance()
    lateinit var binding: FragmentDashboardBinding
    private val provider: PreferenceProvider by instance()
    var expertID = ""

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_dashboard, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        dashboardViewModel =
            ViewModelProvider(this, settingFactory).get(SettingViewModel::class.java)
        getAvailabilityList()

        dashboardViewModel.getAvailabilityResult.observe(viewLifecycleOwner, Observer {
            if (!it.error!!) {
                addAvailabilityLayout.visibility = View.GONE
                initAvailabilityList(it.data!!)
            } else {
                addAvailabilityLayout.visibility = View.VISIBLE
                availableListLayout.visibility = View.GONE
            }
        })

        dashboardViewModel.changeAvailabilityStatusResult.observe(viewLifecycleOwner, Observer {
            if (!it.error)
                getAvailabilityList()
        })

        dashboardViewModel.deleteAvailabilityResult.observe(viewLifecycleOwner, Observer {
            if (!it.error)
                getAvailabilityList()
        })


        addAvailabilityLayout.setOnClickListener {

            startActivity(Intent(context, TimeDateActivity::class.java))
        }

        addNewAvailabilityButton.setOnClickListener {
            startActivity(
                Intent(
                    context,
                    TimeDateActivity::class.java
                )
            )
        }
    }

    override fun onResume() {
        super.onResume()
        getAvailabilityList()

    }


    private fun getAvailabilityList() {
        expertID = provider.getValueByKey("expertID")!!
        val map = HashMap<String, String>()
        map["expertID"] = expertID
        dashboardViewModel.getExpertAvailabilityList(map)

    }

    private fun initAvailabilityList(arraylist: ArrayList<AvailabilityModel>) {
        val availabilityAdapter = AvailabilityAdapter().apply {
            addItems(arraylist)
        }
        availabilityRecyclerView.apply {
            adapter = availabilityAdapter
        }

        availabilityAdapter.listener = { view, item, position ->
            if (view.tag.toString() == "CancelAvailability") {
                showConfirmationMessage(
                    item.id,
                    "NA",
                    "Are you sure you want to delete your schedule?", "Delete"
                )
            } else {
                val switchView = view as SwitchMaterial
                if (switchView.isChecked) {
                    showConfirmationMessage(
                        item.id,
                        "1",
                        "Are you sure you want to enable your schedule?", "Other"
                    )
                } else {
                    showConfirmationMessage(
                        item.id,
                        "0",
                        "Are you sure you want to disable your schedule?", "Other"
                    )
                }
            }

        }
    }


    private fun showConfirmationMessage(
        scheduleID: String,
        status: String,
        message: String,
        type: String
    ) {
        val builder = AlertDialog.Builder(requireContext())
        builder.setMessage(message)
        builder.setPositiveButton("Yes") { dialogInterface, _ ->
            if (type == "Delete")
                dashboardViewModel.deleteAvailability(scheduleID)
            else
                dashboardViewModel.changeAvailabilityStatus(scheduleID, status)
            dialogInterface.dismiss()

        }
        builder.setNegativeButton("No") { dialogInterface, _ ->
            if (type != "Delete")
                getAvailabilityList()
            dialogInterface.dismiss()
        }
        val alertDialog: AlertDialog = builder.create()
        alertDialog.setCancelable(false)
        alertDialog.show()
    }

}