package com.siguiente.fasalexpert.ui.settings

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasalexpert.network.Repository
import com.siguiente.fasalexpert.network.response.AvailabilityListResponse
import com.siguiente.fasalexpert.network.response.CommonResponse
import com.siguiente.fasalexpert.utils.ApiException
import com.siguiente.fasalexpert.utils.Coroutines
import com.siguiente.fasalexpert.utils.NoInternetException

class SettingViewModel(
    private val repository: Repository
) : ViewModel() {

    var addAvailabilityResult = MutableLiveData<CommonResponse>()
    var deleteAvailabilityResult = MutableLiveData<CommonResponse>()
    var changeAvailabilityStatusResult = MutableLiveData<CommonResponse>()
    var getAvailabilityResult = MutableLiveData<AvailabilityListResponse>()

    fun addAvailability(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.addAvailability(field)
                addAvailabilityResult.value = response
                Log.e("addAvailabilityResult", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun getExpertAvailabilityList(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getExpertAvailabilityList(field)
                getAvailabilityResult.value = response
                Log.i("getAvailabilityResult", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun changeAvailabilityStatus(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.changeAvailabilityStatus(field)
                changeAvailabilityStatusResult.value = response
                Log.e("changeAvailabilityS", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun changeAvailabilityStatus(scheduleID:String,status:String){
        val map = HashMap<String, String>()
        map["scheduleID"] = scheduleID
        map["status"] = status
        changeAvailabilityStatus(map)

    }

    fun deleteAvailability(scheduleID:String){
        val map = HashMap<String, String>()
        map["scheduleID"] = scheduleID
        deleteAvailability(map)

    }

    fun deleteAvailability(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.deleteAvailability(field)
                deleteAvailabilityResult.value = response
                Log.e("deleteAvailability", "" + response.toString())
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}