
package com.siguiente.fasalexpert.ui.videos
/*

import android.annotation.SuppressLint
import android.content.Intent
import android.content.SharedPreferences
import android.content.pm.PackageManager
import android.media.*
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.os.CountDownTimer
import android.preference.PreferenceManager
import android.util.Log
import android.view.View
import android.view.WindowManager
import android.widget.*
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import com.google.android.material.floatingactionbutton.FloatingActionButton
import com.google.android.material.snackbar.Snackbar
import com.siguiente.fasalexpert.R
import com.twilio.video.*
import com.twilio.video.Video.connect
import com.twilio.video.VideoView
import io.agora.rtc.mediaio.CameraSource
import io.agora.rtc.video.VideoRenderer
import kotlinx.android.synthetic.main.activity_video_ringing.*
import kotlinx.android.synthetic.main.content_video.*
import org.json.JSONException
import org.json.JSONObject
import java.util.*


class VideoActivity() : AppCompatActivity() {
    private var accessToken: String? = null
    private var room: Room? = null
    private var localParticipant: LocalParticipant? = null
    private var audioCodec: AudioCodec? = null
    private var videoCodec: VideoCodec? = null
    private var encodingParameters: EncodingParameters? = null
    private var primaryVideoView: VideoView? = null
    private var thumbnailVideoView: VideoView? = null
    private var preferences: SharedPreferences? = null
    private var videoStatusTextView: TextView? = null
    private var cameraCapturerCompat: CameraCapturerCompat? = null
    private var localAudioTrack: LocalAudioTrack? = null
    private var localVideoTrack: LocalVideoTrack? = null
    private var connectActionFab: FloatingActionButton? = null
    private var switchCameraActionFab: FloatingActionButton? = null
    private var localVideoActionFab: FloatingActionButton? = null
    private var muteActionFab: FloatingActionButton? = null
    private var speaker_action_fab: FloatingActionButton? = null
    private var reconnectingProgressBar: ProgressBar? = null
    private var audioManager: AudioManager? = null
    private var remoteParticipantIdentity: String? = null
    private var previousAudioMode = 0
    private var previousMicrophoneMute = false
    private var localVideoView: VideoRenderer? = null
    private var disconnectedFromOnDestroy = false
    private var isSpeakerPhoneEnabled = true
    private var enableAutomaticSubscription = false
    private var caller_id: String? = null
    var caller_name: String? = null
    private var caller_image: String? = null
    private var call_status: String? = null
    private var call_type: String? = null
    var roomname: String? = null

    var ringtoneSound: Ringtone? = null
    var calling_action_btns: LinearLayout? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window.addFlags(
            WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
                    or WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
                    or WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON
                    or WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON
        )
        setContentView(R.layout.activity_video)
       // identity = SharedPrefrence.get_string(this, SharedPrefrence.u_id)
        //rootref = FirebaseDatabase.getInstance().getReference()
        val ringtoneUri = RingtoneManager.getDefaultUri(RingtoneManager.TYPE_RINGTONE)
        ringtoneSound = RingtoneManager.getRingtone(applicationContext, ringtoneUri)
        primaryVideoView = findViewById(R.id.primary_video_view)
        thumbnailVideoView = findViewById(R.id.thumbnail_video_view)
        videoStatusTextView = findViewById(R.id.video_status_textview)
        reconnectingProgressBar = findViewById(R.id.reconnecting_progress_bar)
        calling_action_btns = findViewById(R.id.calling_action_btns)
        connectActionFab = findViewById(R.id.connect_action_fab)
        switchCameraActionFab = findViewById(R.id.switch_camera_action_fab)
        localVideoActionFab = findViewById(R.id.local_video_action_fab)
        muteActionFab = findViewById(R.id.mute_action_fab)
        speaker_action_fab = findViewById(R.id.speaker_action_fab)
        preferences = PreferenceManager.getDefaultSharedPreferences(this)
        volumeControlStream = AudioManager.STREAM_VOICE_CALL
        audioManager = getSystemService(AUDIO_SERVICE) as AudioManager
        audioManager!!.isSpeakerphoneOn = isSpeakerPhoneEnabled
        val intent = intent
        onNewIntent(intent)
        createAudioAndVideoTracks()
      //  retrieveAccessTokenfromServer()
        intializeUI()
        get_user_token()
    }
*/
/*
    var caller_token = "null"
    fun get_user_token() {
        rootref.child("Users")
            .child(caller_id).addListenerForSingleValueEvent(object : ValueEventListener() {
                fun onDataChange(dataSnapshot: DataSnapshot) {
                    if (dataSnapshot != null && dataSnapshot.hasChild("token")) {
                        caller_token = dataSnapshot.child("token").getValue().toString()
                    }
                    Show_Calling_Dialog()
                }

                fun onCancelled(databaseError: DatabaseError) {}
            })
    }*//*


   */
/* var countDownTimer: CountDownTimer? = null
    fun Start_Countdown_timer() {
        countDownTimer = object : CountDownTimer(60000, 2000) {
            override fun onTick(millisUntilFinished: Long) {}
            override fun onFinish() {
                Send_notification(Call_not_Pick, "Calling you...")
                disconnectClickListener()
                finish()
            }
        }
        countDownTimer.start()
    }*//*


   */
/* fun Stop_timer() {
        if (countDownTimer != null) {
            countDownTimer!!.cancel()
        }
    }*//*


    override fun onNewIntent(intent: Intent) {
        super.onNewIntent(intent)
        caller_id = intent.getStringExtra("id")
        caller_name = intent.getStringExtra("name")
        caller_image = intent.getStringExtra("image")
        call_status = intent.getStringExtra("status")
        call_type = intent.getStringExtra("call_type")
        roomname = intent.getStringExtra("roomname")
        do_action_on_status()
    }

    var calling_status_txt: TextView? = null
    var calling_user_info_layout: RelativeLayout? = null
    fun Show_Calling_Dialog() {
        calling_user_info_layout = findViewById(R.id.calling_user_info_layout)
        calling_user_info_layout.setVisibility(View.VISIBLE)
        calling_action_btns!!.visibility = View.GONE
        val userimage: SimpleDraweeView = findViewById(R.id.userimage)
        val username = findViewById<TextView>(R.id.username)
        calling_status_txt = findViewById(R.id.calling_status_txt)
        if (caller_image != null && caller_image != "") {
            val uri = Uri.parse(caller_image)
            userimage.setImageURI(uri)
        } else {
            val uri = Uri.parse("null")
            userimage.setImageURI(uri)
        }
        username.text = caller_name
        val receive_disconnect_layout = findViewById<RelativeLayout>(R.id.receive_disconnect_layout)
        val pick_incoming_call = findViewById<ImageButton>(R.id.pick_incoming_call)
        val cancel_incoming_btn = findViewById<ImageButton>(R.id.cancel_incoming_btn)
        pick_incoming_call.setOnClickListener {
            if (accessToken != null) {
                if ((call_type == "video_call")) calling_user_info_layout.setVisibility(View.GONE) else {
                    switchCameraActionFab!!.visibility = View.GONE
                    localVideoActionFab!!.visibility = View.GONE
                    findViewById<View>(R.id.receive_disconnect_layout).visibility =
                        View.GONE
                    findViewById<View>(R.id.cancel_call).visibility =
                        View.GONE
                }
                calling_action_btns!!.visibility = View.VISIBLE
                if (ringtoneSound != null) {
                    ringtoneSound!!.stop()
                }
                connectToRoom(roomname)
                Send_notification(Call_Pick, "Pick your Call")
            }
        }
        cancel_incoming_btn.setOnClickListener {
            Send_notification(Call_not_Pick, "Hang out your call")
            if (ringtoneSound != null) {
                ringtoneSound!!.stop()
            }
            finish()
        }
        val cancel_call = findViewById<ImageButton>(R.id.cancel_call)
        cancel_call.visibility = View.VISIBLE
        cancel_call.setOnClickListener {
            Send_notification(Call_not_Pick, "Hang out your call")
            disconnectClickListener()
            finish()
        }
        if ((call_status == Call_Send)) {
            receive_disconnect_layout.visibility = View.GONE
            cancel_call.visibility = View.VISIBLE
            Send_notification(Call_Receive, "Calling you...")
            Start_Countdown_timer()
        } else if ((call_status == Call_Receive)) {
            receive_disconnect_layout.visibility = View.VISIBLE
            cancel_call.visibility = View.GONE
            calling_status_txt.setText("Calling you")
            Send_notification(Call_Ringing, "Ringing...")
        }
    }

    @SuppressLint("RestrictedApi")
    fun do_action_on_status() {
        if ((call_status == Call_Pick)) {
            if (accessToken != null && calling_user_info_layout != null) {
                Stop_timer()
                if ((call_type == "video_call")) calling_user_info_layout!!.visibility =
                    View.GONE else {
                    switchCameraActionFab!!.visibility = View.GONE
                    localVideoActionFab!!.visibility = View.GONE
                    findViewById<View>(R.id.receive_disconnect_layout).visibility =
                        View.GONE
                    findViewById<View>(R.id.cancel_call).visibility = View.GONE
                }
                calling_action_btns!!.visibility = View.VISIBLE
                connectToRoom(roomname)
                Toast.makeText(this, "Pick call", Toast.LENGTH_SHORT).show()
            }
        } else if ((call_status == Call_Receive)) {
            if (ringtoneSound != null) {
                ringtoneSound!!.play()
            }
        } else if ((call_status == Call_Ringing)) {
            if (calling_status_txt != null) calling_status_txt!!.text = "Ringing..."
        } else if ((call_status == Call_not_Pick)) {
            if (ringtoneSound != null) {
                ringtoneSound!!.stop()
            }
            Toast.makeText(this, "$caller_name hang out the call", Toast.LENGTH_SHORT).show()
            finish()
        }
    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<String>,
        grantResults: IntArray
    ) {
        if (requestCode == CAMERA_MIC_PERMISSION_REQUEST_CODE) {
            var cameraAndMicPermissionGranted = true
            for (grantResult: Int in grantResults) {
                cameraAndMicPermissionGranted =
                    cameraAndMicPermissionGranted and (grantResult == PackageManager.PERMISSION_GRANTED)
            }
            if (cameraAndMicPermissionGranted) {
                createAudioAndVideoTracks()
              //  retrieveAccessTokenfromServer()
            } else {
                Toast.makeText(
                    this,
                    "Need mic and speaker permission",
                    Toast.LENGTH_LONG
                ).show()
            }
        }
    }

    override fun onStart() {
        is_calling_activity_open = true
        audioCodec = getAudioCodecPreference(
            TwilioSettings.PREF_AUDIO_CODEC,
            TwilioSettings.PREF_AUDIO_CODEC_DEFAULT
        )
        videoCodec = getVideoCodecPreference(
            TwilioSettings.PREF_VIDEO_CODEC,
            TwilioSettings.PREF_VIDEO_CODEC_DEFAULT
        )
        enableAutomaticSubscription = getAutomaticSubscriptionPreference(
            TwilioSettings.PREF_ENABLE_AUTOMATIC_SUBSCRIPTION,
            TwilioSettings.PREF_ENABLE_AUTOMATIC_SUBSCRIPTION_DEFAULT
        )
        val newEncodingParameters = getEncodingParameters()
        if (localVideoTrack == null && (call_type == "video_call")) {
            if (cameraCapturerCompat == null) cameraCapturerCompat = CameraCapturerCompat(
                this,
                availableCameraSource
            )
            localVideoTrack = LocalVideoTrack.create(
                this,
                true,
                cameraCapturerCompat.getVideoCapturer(),
                LOCAL_VIDEO_TRACK_NAME
            )
            localVideoTrack.addRenderer(localVideoView)
            if (localParticipant != null) {
                localParticipant!!.publishTrack((localVideoTrack)!!)
                if (newEncodingParameters != encodingParameters) {
                    localParticipant!!.setEncodingParameters(newEncodingParameters)
                }
            }
        }
        encodingParameters = newEncodingParameters
        audioManager!!.isSpeakerphoneOn = isSpeakerPhoneEnabled
        if (room != null) {
            reconnectingProgressBar!!.visibility =
                if ((room!!.state != Room.State.RECONNECTING)) View.GONE else View.VISIBLE
            videoStatusTextView!!.text = "Connected to $caller_name"
        }
        super.onStart()
    }

    override fun onStop() {
        if (localVideoTrack != null) {
            if (localParticipant != null) {
                localParticipant!!.unpublishTrack(localVideoTrack!!)
            }
            localVideoTrack!!.release()
            localVideoTrack = null
        }
        super.onStop()
    }

    override fun onDestroy() {
        is_calling_activity_open = false
        configureAudio(false)
        if (ringtoneSound != null && ringtoneSound!!.isPlaying) {
            ringtoneSound!!.stop()
        }
        if (room != null && room!!.state != Room.State.DISCONNECTED) {
            room!!.disconnect()
            disconnectedFromOnDestroy = true
        }
        if (localAudioTrack != null) {
            localAudioTrack!!.release()
            localAudioTrack = null
        }
        if (localVideoTrack != null) {
            localVideoTrack!!.release()
            localVideoTrack = null
        }
        Stop_limit_timer()
        super.onDestroy()
    }

    private fun createAudioAndVideoTracks() {
        try {
            localAudioTrack = LocalAudioTrack.create(this, true, LOCAL_AUDIO_TRACK_NAME)
            if ((call_type == "video_call")) {
                cameraCapturerCompat = CameraCapturerCompat(this, availableCameraSource)
                localVideoTrack = LocalVideoTrack.create(
                    this,
                    true,
                    cameraCapturerCompat.getVideoCapturer(),
                    LOCAL_VIDEO_TRACK_NAME
                )
                primaryVideoView!!.mirror = true
                if (localVideoTrack != null) {
                    localVideoTrack.addRenderer(primaryVideoView)
                    localVideoView = primaryVideoView
                }
            }
        } catch (e: Exception) {
            Toast.makeText(this, e.toString(), Toast.LENGTH_SHORT).show()
        }
    }

    private val availableCameraSource: CameraSource
        private get() = if ((CameraCapturer.isSourceAvailable(CameraSource.FRONT_CAMERA))) (CameraSource.FRONT_CAMERA) else (CameraSource.BACK_CAMERA)

    private fun connectToRoom(roomName: String?) {
        configureAudio(true)
        val connectOptionsBuilder = ConnectOptions.Builder((accessToken)!!)
            .roomName((roomName)!!)
        if (localAudioTrack != null) {
            connectOptionsBuilder
                .audioTracks(listOf(localAudioTrack))
        }
        if (localVideoTrack != null && (call_type == "video_call")) {
            connectOptionsBuilder.videoTracks(listOf(localVideoTrack))
        }
        connectOptionsBuilder.preferAudioCodecs(listOf(audioCodec))
        if ((call_type == "video_call")) connectOptionsBuilder.preferVideoCodecs(listOf(videoCodec))
        connectOptionsBuilder.encodingParameters((encodingParameters)!!)
        connectOptionsBuilder.enableAutomaticSubscription(enableAutomaticSubscription)
        room = connect(this, connectOptionsBuilder.build(), roomListener())
        setDisconnectAction()
    }

    private fun intializeUI() {
        connectActionFab!!.show()
        switchCameraActionFab!!.show()
        switchCameraActionFab!!.setOnClickListener(switchCameraClickListener())
        localVideoActionFab!!.show()
        localVideoActionFab!!.setOnClickListener(localVideoClickListener())
        muteActionFab!!.show()
        muteActionFab!!.setOnClickListener(muteClickListener())
        speaker_action_fab!!.show()
        speaker_action_fab!!.setOnClickListener(speakerClickListener())
    }

    private fun getAudioCodecPreference(key: String, defaultValue: String): AudioCodec {
        val audioCodecName = preferences!!.getString(key, defaultValue)
        when (audioCodecName) {
            IsacCodec.NAME -> return IsacCodec()
            OpusCodec.NAME -> return OpusCodec()
            PcmaCodec.NAME -> return PcmaCodec()
            PcmuCodec.NAME -> return PcmuCodec()
            G722Codec.NAME -> return G722Codec()
            else -> return OpusCodec()
        }
    }

    private fun getVideoCodecPreference(key: String, defaultValue: String): VideoCodec {
        val videoCodecName = preferences!!.getString(key, defaultValue)
        when (videoCodecName) {
            Vp8Codec.NAME -> {
                val simulcast = preferences!!.getBoolean(
                    TwilioSettings.PREF_VP8_SIMULCAST,
                    TwilioSettings.PREF_VP8_SIMULCAST_DEFAULT
                )
                return Vp8Codec(simulcast)
            }
            H264Codec.NAME -> return H264Codec()
            Vp9Codec.NAME -> return Vp9Codec()
            else -> return Vp8Codec()
        }
    }

    private fun getAutomaticSubscriptionPreference(key: String, defaultValue: Boolean): Boolean {
        return preferences!!.getBoolean(key, defaultValue)
    }

    private fun getEncodingParameters(): EncodingParameters {
        val maxAudioBitrate =
            preferences!!.getString(
                TwilioSettings.PREF_SENDER_MAX_AUDIO_BITRATE,
                TwilioSettings.PREF_SENDER_MAX_AUDIO_BITRATE_DEFAULT
            )!!.toInt()
        val maxVideoBitrate =
            preferences!!.getString(
                TwilioSettings.PREF_SENDER_MAX_VIDEO_BITRATE,
                TwilioSettings.PREF_SENDER_MAX_VIDEO_BITRATE_DEFAULT
            )!!.toInt()
        return EncodingParameters(maxAudioBitrate, maxVideoBitrate)
    }

    private fun setDisconnectAction() {
        connectActionFab!!.show()
        connectActionFab!!.setOnClickListener(disconnectClickListener())
    }

    private fun addRemoteParticipant(remoteParticipant: RemoteParticipant) {
        */
/*
         * This app only displays video for one additional participant per Room
         *//*

        if (thumbnailVideoView!!.visibility == View.VISIBLE) {
            Snackbar.make(
                (connectActionFab)!!,
                "Multiple participants are not currently support in this UI",
                Snackbar.LENGTH_LONG
            )
                .setAction("Action", null).show()
            return
        }
        remoteParticipantIdentity = remoteParticipant.identity
        videoStatusTextView!!.text = "$caller_name joined"

        */
/*
         * Add remote participant renderer
         *//*
if (remoteParticipant.remoteVideoTracks.size > 0) {
            val remoteVideoTrackPublication = remoteParticipant.remoteVideoTracks[0]

            */
/*
             * Only render video tracks that are subscribed to
             *//*
if (remoteVideoTrackPublication.isTrackSubscribed) {
                addRemoteParticipantVideo(remoteVideoTrackPublication.remoteVideoTrack)
            }
        }

        */
/*
         * Start listening for participant events
         *//*
remoteParticipant.setListener(remoteParticipantListener())
    }

    private fun addRemoteParticipantVideo(videoTrack: VideoTrack?) {
        moveLocalVideoToThumbnailView()
        primaryVideoView!!.mirror = false
        videoTrack.addRenderer(primaryVideoView)
    }

    private fun moveLocalVideoToThumbnailView() {
        if (thumbnailVideoView!!.visibility == View.GONE) {
            thumbnailVideoView!!.visibility = View.VISIBLE
            localVideoTrack.removeRenderer(primaryVideoView)
            localVideoTrack.addRenderer(thumbnailVideoView)
            localVideoView = thumbnailVideoView
            thumbnailVideoView!!.mirror = cameraCapturerCompat.getCameraSource() ===
                    CameraSource.FRONT_CAMERA
        }
    }

    private fun removeRemoteParticipant(remoteParticipant: RemoteParticipant) {
        videoStatusTextView!!.text = "$caller_name left."
        if (remoteParticipant.identity != remoteParticipantIdentity) {
            return
        }

        */
/*
         * Remove remote participant renderer
         *//*
if (!remoteParticipant.remoteVideoTracks.isEmpty()) {
            val remoteVideoTrackPublication = remoteParticipant.remoteVideoTracks[0]

            */
/*
             * Remove video only if subscribed to participant track
             *//*
if (remoteVideoTrackPublication.isTrackSubscribed) {
                removeParticipantVideo(remoteVideoTrackPublication.remoteVideoTrack)
            }
        }
        moveLocalVideoToPrimaryView()
        if (remoteParticipant.identity.contains((caller_id)!!)) {
            Toast.makeText(this, "$caller_name hang out the call", Toast.LENGTH_SHORT).show()
            finish()
        }
    }

    private fun removeParticipantVideo(videoTrack: VideoTrack?) {
        videoTrack.removeRenderer(primaryVideoView)
    }

    private fun moveLocalVideoToPrimaryView() {
        if (thumbnailVideoView!!.visibility == View.VISIBLE) {
            thumbnailVideoView!!.visibility = View.GONE
            if (localVideoTrack != null) {
                localVideoTrack.removeRenderer(thumbnailVideoView)
                localVideoTrack.addRenderer(primaryVideoView)
            }
            localVideoView = primaryVideoView
            primaryVideoView!!.mirror = cameraCapturerCompat.getCameraSource() ===
                    CameraSource.FRONT_CAMERA
        }
    }

    private fun roomListener(): Room.Listener {
        return object : Room.Listener {
            override fun onConnected(room: Room) {
                localParticipant = room.localParticipant
                videoStatusTextView!!.text = "Connected to $caller_name"
                calling_status_txt!!.text = "Connected"
                title = room.name
                Start_limit_Timer()
                for (remoteParticipant: RemoteParticipant in room.remoteParticipants) {
                    addRemoteParticipant(remoteParticipant)
                    break
                }
            }

            override fun onReconnecting(room: Room, twilioException: TwilioException) {
                videoStatusTextView!!.text = "Reconnecting to $caller_name"
                calling_status_txt!!.text = "Reconnecting"
                reconnectingProgressBar!!.visibility = View.VISIBLE
            }

            override fun onReconnected(room: Room) {
                videoStatusTextView!!.text = "Connected to " + room.name
                calling_status_txt!!.text = "Connected"
                reconnectingProgressBar!!.visibility = View.GONE
            }

            override fun onConnectFailure(room: Room, e: TwilioException) {
                videoStatusTextView!!.text = "Failed to connect"
                calling_status_txt!!.text = "Disconnected"
                configureAudio(false)
                intializeUI()
            }

            override fun onDisconnected(room: Room, e: TwilioException?) {
                localParticipant = null
                videoStatusTextView!!.text = "Disconnected from $caller_name"
                reconnectingProgressBar!!.visibility = View.GONE
                this@VideoActivity.room = null
                // Only reinitialize the UI if disconnect was not called from onDestroy()
                if (!disconnectedFromOnDestroy) {
                    configureAudio(false)
                    intializeUI()
                    moveLocalVideoToPrimaryView()
                }
                Stop_limit_timer()
            }

            override fun onParticipantConnected(room: Room, remoteParticipant: RemoteParticipant) {
                addRemoteParticipant(remoteParticipant)
            }

            override fun onParticipantDisconnected(
                room: Room,
                remoteParticipant: RemoteParticipant
            ) {
                removeRemoteParticipant(remoteParticipant)
            }

            override fun onRecordingStarted(room: Room) {
                Log.d(TAG, "onRecordingStarted")
            }

            override fun onRecordingStopped(room: Room) {
                Log.d(TAG, "onRecordingStopped")
            }
        }
    }

    private fun remoteParticipantListener(): RemoteParticipant.Listener {
        return object : RemoteParticipant.Listener {
            override fun onAudioTrackPublished(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication
            ) {
                Log.i(
                    TAG, String.format(
                        ("onAudioTrackPublished: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteAudioTrackPublication: sid=%s, enabled=%b, " +
                                "subscribed=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteAudioTrackPublication.trackSid,
                        remoteAudioTrackPublication.isTrackEnabled,
                        remoteAudioTrackPublication.isTrackSubscribed,
                        remoteAudioTrackPublication.trackName
                    )
                )
                videoStatusTextView!!.text = "Audio Connected"
            }

            override fun onAudioTrackUnpublished(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication
            ) {
                Log.i(
                    TAG, String.format(
                        ("onAudioTrackUnpublished: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteAudioTrackPublication: sid=%s, enabled=%b, " +
                                "subscribed=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteAudioTrackPublication.trackSid,
                        remoteAudioTrackPublication.isTrackEnabled,
                        remoteAudioTrackPublication.isTrackSubscribed,
                        remoteAudioTrackPublication.trackName
                    )
                )
                videoStatusTextView!!.text = "Audio Unpublished"
            }

            override fun onDataTrackPublished(
                remoteParticipant: RemoteParticipant,
                remoteDataTrackPublication: RemoteDataTrackPublication
            ) {
                Log.i(
                    TAG, String.format(
                        ("onDataTrackPublished: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteDataTrackPublication: sid=%s, enabled=%b, " +
                                "subscribed=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteDataTrackPublication.trackSid,
                        remoteDataTrackPublication.isTrackEnabled,
                        remoteDataTrackPublication.isTrackSubscribed,
                        remoteDataTrackPublication.trackName
                    )
                )
            }

            override fun onDataTrackUnpublished(
                remoteParticipant: RemoteParticipant,
                remoteDataTrackPublication: RemoteDataTrackPublication
            ) {
                Log.i(
                    TAG, String.format(
                        ("onDataTrackUnpublished: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteDataTrackPublication: sid=%s, enabled=%b, " +
                                "subscribed=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteDataTrackPublication.trackSid,
                        remoteDataTrackPublication.isTrackEnabled,
                        remoteDataTrackPublication.isTrackSubscribed,
                        remoteDataTrackPublication.trackName
                    )
                )
            }

            override fun onVideoTrackPublished(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication
            ) {
                Log.i(
                    TAG, String.format(
                        ("onVideoTrackPublished: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteVideoTrackPublication: sid=%s, enabled=%b, " +
                                "subscribed=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteVideoTrackPublication.trackSid,
                        remoteVideoTrackPublication.isTrackEnabled,
                        remoteVideoTrackPublication.isTrackSubscribed,
                        remoteVideoTrackPublication.trackName
                    )
                )
                videoStatusTextView!!.text = "Video Connected"
            }

            override fun onVideoTrackUnpublished(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication
            ) {
                Log.i(
                    TAG, String.format(
                        ("onVideoTrackUnpublished: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteVideoTrackPublication: sid=%s, enabled=%b, " +
                                "subscribed=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteVideoTrackPublication.trackSid,
                        remoteVideoTrackPublication.isTrackEnabled,
                        remoteVideoTrackPublication.isTrackSubscribed,
                        remoteVideoTrackPublication.trackName
                    )
                )
                videoStatusTextView!!.text = "Video Unpublished"
            }

            override fun onAudioTrackSubscribed(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication,
                remoteAudioTrack: RemoteAudioTrack
            ) {
                Log.i(
                    TAG, String.format(
                        ("onAudioTrackSubscribed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteAudioTrack: enabled=%b, playbackEnabled=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteAudioTrack.isEnabled,
                        remoteAudioTrack.isPlaybackEnabled,
                        remoteAudioTrack.name
                    )
                )
                videoStatusTextView!!.text = "Audio Subscribed"
            }

            override fun onAudioTrackUnsubscribed(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication,
                remoteAudioTrack: RemoteAudioTrack
            ) {
                Log.i(
                    TAG, String.format(
                        ("onAudioTrackUnsubscribed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteAudioTrack: enabled=%b, playbackEnabled=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteAudioTrack.isEnabled,
                        remoteAudioTrack.isPlaybackEnabled,
                        remoteAudioTrack.name
                    )
                )
                videoStatusTextView!!.text = "Audio Unsubscribed"
            }

            override fun onAudioTrackSubscriptionFailed(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication,
                twilioException: TwilioException
            ) {
                Log.i(
                    TAG, String.format(
                        ("onAudioTrackSubscriptionFailed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteAudioTrackPublication: sid=%b, name=%s]" +
                                "[TwilioException: code=%d, message=%s]"),
                        remoteParticipant.identity,
                        remoteAudioTrackPublication.trackSid,
                        remoteAudioTrackPublication.trackName,
                        twilioException.code,
                        twilioException.message
                    )
                )
                videoStatusTextView!!.text = "Audio SubscriptionFailed"
            }

            override fun onDataTrackSubscribed(
                remoteParticipant: RemoteParticipant,
                remoteDataTrackPublication: RemoteDataTrackPublication,
                remoteDataTrack: RemoteDataTrack
            ) {
                Log.i(
                    TAG, String.format(
                        ("onDataTrackSubscribed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteDataTrack: enabled=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteDataTrack.isEnabled,
                        remoteDataTrack.name
                    )
                )
            }

            override fun onDataTrackUnsubscribed(
                remoteParticipant: RemoteParticipant,
                remoteDataTrackPublication: RemoteDataTrackPublication,
                remoteDataTrack: RemoteDataTrack
            ) {
                Log.i(
                    TAG, String.format(
                        ("onDataTrackUnsubscribed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteDataTrack: enabled=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteDataTrack.isEnabled,
                        remoteDataTrack.name
                    )
                )
            }

            override fun onDataTrackSubscriptionFailed(
                remoteParticipant: RemoteParticipant,
                remoteDataTrackPublication: RemoteDataTrackPublication,
                twilioException: TwilioException
            ) {
                Log.i(
                    TAG, String.format(
                        ("onDataTrackSubscriptionFailed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteDataTrackPublication: sid=%b, name=%s]" +
                                "[TwilioException: code=%d, message=%s]"),
                        remoteParticipant.identity,
                        remoteDataTrackPublication.trackSid,
                        remoteDataTrackPublication.trackName,
                        twilioException.code,
                        twilioException.message
                    )
                )
            }

            override fun onVideoTrackSubscribed(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication,
                remoteVideoTrack: RemoteVideoTrack
            ) {
                Log.i(
                    TAG, String.format(
                        ("onVideoTrackSubscribed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteVideoTrack: enabled=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteVideoTrack.isEnabled,
                        remoteVideoTrack.name
                    )
                )
                videoStatusTextView!!.text = "Video Subscribed"
                addRemoteParticipantVideo(remoteVideoTrack)
            }

            override fun onVideoTrackUnsubscribed(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication,
                remoteVideoTrack: RemoteVideoTrack
            ) {
                Log.i(
                    TAG, String.format(
                        ("onVideoTrackUnsubscribed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteVideoTrack: enabled=%b, name=%s]"),
                        remoteParticipant.identity,
                        remoteVideoTrack.isEnabled,
                        remoteVideoTrack.name
                    )
                )
                videoStatusTextView!!.text = "Video Unsubscribed"
                removeParticipantVideo(remoteVideoTrack)
            }

            override fun onVideoTrackSubscriptionFailed(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication,
                twilioException: TwilioException
            ) {
                Log.i(
                    TAG, String.format(
                        ("onVideoTrackSubscriptionFailed: " +
                                "[RemoteParticipant: identity=%s], " +
                                "[RemoteVideoTrackPublication: sid=%b, name=%s]" +
                                "[TwilioException: code=%d, message=%s]"),
                        remoteParticipant.identity,
                        remoteVideoTrackPublication.trackSid,
                        remoteVideoTrackPublication.trackName,
                        twilioException.code,
                        twilioException.message
                    )
                )
                videoStatusTextView!!.text = "Video Subscription Failed"
                Snackbar.make(
                    (connectActionFab)!!, String.format(
                        "Failed to subscribe to %s video track",
                        remoteParticipant.identity
                    ),
                    Snackbar.LENGTH_LONG
                )
                    .show()
            }

            override fun onAudioTrackEnabled(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication
            ) {
            }

            override fun onAudioTrackDisabled(
                remoteParticipant: RemoteParticipant,
                remoteAudioTrackPublication: RemoteAudioTrackPublication
            ) {
            }

            override fun onVideoTrackEnabled(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication
            ) {
            }

            override fun onVideoTrackDisabled(
                remoteParticipant: RemoteParticipant,
                remoteVideoTrackPublication: RemoteVideoTrackPublication
            ) {
            }
        }
    }

    private fun disconnectClickListener(): View.OnClickListener {
        return View.OnClickListener {
            if (room != null) {
                room!!.disconnect()
            }
            intializeUI()
            finish()
        }
    }

    private fun switchCameraClickListener(): View.OnClickListener {
        return View.OnClickListener {
            if (cameraCapturerCompat != null) {
                val cameraSource: CameraSource = cameraCapturerCompat.getCameraSource()
                cameraCapturerCompat!!.switchCamera()
                if (thumbnailVideoView!!.visibility == View.VISIBLE) {
                    thumbnailVideoView!!.mirror = cameraSource === CameraCapturerCompat.Source.BACK_CAMERA
                } else {
                    primaryVideoView!!.mirror = cameraSource === CameraCapturerCompat.Source.BACK_CAMERA
                }
            }
        }
    }

    private fun localVideoClickListener(): View.OnClickListener {
        return View.OnClickListener { */
/*
                     * Enable/disable the local video track
                     *//*

            if (localVideoTrack != null) {
                val enable = !localVideoTrack!!.isEnabled
                localVideoTrack!!.enable(enable)
                val icon: Int
                if (enable) {
                    icon = R.drawable.ic_videocam_white_24dp
                    switchCameraActionFab!!.show()
                } else {
                    icon = R.drawable.ic_videocam_off_black_24dp
                    switchCameraActionFab!!.hide()
                }
                localVideoActionFab!!.setImageDrawable(
                    ContextCompat.getDrawable(this@VideoActivity, icon)
                )
            }
        }
    }

    private fun muteClickListener(): View.OnClickListener {
        return View.OnClickListener { */
/*
                     * Enable/disable the local audio track. The results of this operation are
                     * signaled to other Participants in the same Room. When an audio track is
                     * disabled, the audio is muted.
                     *//*

            if (localAudioTrack != null) {
                val enable = !localAudioTrack!!.isEnabled
                localAudioTrack!!.enable(enable)
                val icon =
                    if (enable) R.drawable.ic_mic_white_24dp else R.drawable.ic_mic_off_black_24dp
                muteActionFab!!.setImageDrawable(
                    ContextCompat.getDrawable(
                        this@VideoActivity, icon
                    )
                )
            }
        }
    }

    private fun speakerClickListener(): View.OnClickListener {
        return View.OnClickListener {
            if (audioManager!!.isSpeakerphoneOn) {
                audioManager!!.isSpeakerphoneOn = false
                speaker_action_fab!!.setImageResource(R.drawable.ic_volume_mute_black_24dp)
                isSpeakerPhoneEnabled = false
            } else {
                audioManager!!.isSpeakerphoneOn = true
                speaker_action_fab!!.setImageResource(R.drawable.ic_volume_up_white_24dp)
                isSpeakerPhoneEnabled = true
            }
        }
    }

    */
/*private fun retrieveAccessTokenfromServer() {
        Log.d(
            "resp",
            Api_Links.TWILIO_ACCESS_TOKEN_SERVER.toString() + identity + "?roomname=" + roomname
        )
        val postRequest = StringRequest(Request.Method.GET,
            Api_Links.TWILIO_ACCESS_TOKEN_SERVER.toString() + identity + "?roomname=" + roomname,
            object : Listener<String?>() {
                fun onResponse(response: String?) {
                    Log.d("resp", (response)!!)
                    try {
                        val jsonObject = JSONObject(response)
                        val token = jsonObject.optString("token")
                        accessToken = token
                    } catch (e: JSONException) {
                        e.printStackTrace()
                    }
                }
            },
            object : ErrorListener() {
                fun onErrorResponse(error: VolleyError?) {}
            }
        )
        val requestQueue: RequestQueue = Volley.newRequestQueue(this)
        postRequest.setRetryPolicy(
            DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT
            )
        )
        requestQueue.getCache().clear()
        requestQueue.add(postRequest)
    }*//*


    private fun configureAudio(enable: Boolean) {
        if (enable) {
            previousAudioMode = audioManager!!.mode
            // Request audio focus before making any device switch
            requestAudioFocus()
            */
/*
             * Use MODE_IN_COMMUNICATION as the default audio mode. It is required
             * to be in this mode when playout and/or recording starts for the best
             * possible VoIP performance. Some devices have difficulties with
             * speaker mode if this is not set.
             *//*
audioManager!!.mode = AudioManager.MODE_IN_COMMUNICATION
            */
/*
             * Always disable microphone mute during a WebRTC call.
             *//*
previousMicrophoneMute = audioManager!!.isMicrophoneMute
            audioManager!!.isMicrophoneMute = false
        } else {
            audioManager!!.mode = previousAudioMode
            audioManager!!.abandonAudioFocus(null)
            audioManager!!.isMicrophoneMute = previousMicrophoneMute
        }
    }

    private fun requestAudioFocus() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val playbackAttributes = AudioAttributes.Builder()
                .setUsage(AudioAttributes.USAGE_VOICE_COMMUNICATION)
                .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH)
                .build()
            val focusRequest = AudioFocusRequest.Builder(AudioManager.AUDIOFOCUS_GAIN_TRANSIENT)
                .setAudioAttributes(playbackAttributes)
                .setAcceptsDelayedFocusGain(true)
                .setOnAudioFocusChangeListener { }
                .build()
            audioManager!!.requestAudioFocus(focusRequest)
        } else {
            audioManager!!.requestAudioFocus(
                null, AudioManager.STREAM_VOICE_CALL,
                AudioManager.AUDIOFOCUS_GAIN_TRANSIENT
            )
        }
    }

  */
/*  fun Send_notification(call_status: String?, message: String?) {
        val name: String = Functions.get_info(this@VideoActivity, "first_name")
            .toString() + " " + Functions.get_info(this@VideoActivity, "last_name")
        val json = JSONObject()
        try {
            json.put("to", caller_token)
            val info = JSONObject()
            info.put("senderId", SharedPrefrence.get_string(this, SharedPrefrence.u_id))
            info.put("senderImage", "")
            info.put("title", name)
            info.put("body", message)
            info.put("type", call_type)
            info.put("action", call_status)
            info.put("message", roomname)
            val ttl = JSONObject()
            ttl.put("ttl", "5s")
            json.put("notification", info)
            json.put("data", info)
            json.put("android", ttl)
        } catch (e: JSONException) {
            e.printStackTrace()
        }
        ApiRequest.Send_Notification(this, json, object : CallBack() {
            fun Get_Response(requestType: String?, response: String?) {}
        })
    }*//*


  */
/*  private var limit_countDownTimer: CountDownTimer? = null
    fun Start_limit_Timer() {
        limit_countDownTimer = object : CountDownTimer(Variables.max_video_calling_time, 1000) {
            override fun onTick(millisUntilFinished: Long) {
                if ((call_type == "video_call")) {
                    val call_time: Int = SharedPrefrence.get_int(
                        this@VideoActivity,
                        SharedPrefrence.video_calling_used_time
                    )
                    SharedPrefrence.save_int(
                        this@VideoActivity,
                        call_time + 1000,
                        SharedPrefrence.video_calling_used_time
                    )
                    if (call_time > Variables.max_streming_time) {
                        connectActionFab!!.performClick()
                    }
                } else {
                    val call_time: Int = SharedPrefrence.get_int(
                        this@VideoActivity,
                        SharedPrefrence.voice_calling_used_time
                    )
                    SharedPrefrence.save_int(
                        this@VideoActivity,
                        call_time + 1000,
                        SharedPrefrence.voice_calling_used_time
                    )
                    if (call_time > Variables.max_voice_calling_time) {
                        connectActionFab!!.performClick()
                    }
                }
            }

            override fun onFinish() {
                connectActionFab!!.performClick()
            }
        }.start()
    }*//*


   */
/* fun Stop_limit_timer() {
        if (limit_countDownTimer != null) {
            limit_countDownTimer!!.cancel()
        }
    }*//*


    companion object {
        private const val CAMERA_MIC_PERMISSION_REQUEST_CODE = 1
        private const val TAG = "VideoActivity"
        var is_calling_activity_open = false
        const val Call_Receive = "Call_Receive"
        const val Call_Send = "Call_Send"
        const val Call_Ringing = "Call_Ringing"
        const val Call_Pick = "Call_Pick"
        const val Call_not_Pick = "Call_not_Pick"
        private const val LOCAL_AUDIO_TRACK_NAME = "mic"
        private const val LOCAL_VIDEO_TRACK_NAME = "camera"
        var identity: String? = null
    }
}
*/
