package com.siguiente.fasalexpert.utility

import android.app.Application
import com.siguiente.fasal.login.ui.login.LoginViewModelFactory
import com.siguiente.fasalexpert.network.MyApi
import com.siguiente.fasalexpert.R
import com.siguiente.fasalexpert.network.NetworkConnectionInterceptor
import com.siguiente.fasalexpert.network.Repository
import com.siguiente.fasalexpert.ui.activity.ViewQuestionViewModelFactory
import com.siguiente.fasalexpert.ui.home.HomeViewModelFactory
import com.siguiente.fasalexpert.ui.notifications.NotificationViewModelFactory
import com.siguiente.fasalexpert.ui.settings.SettingViewModelFactory
import org.kodein.di.Kodein
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.androidXModule
import org.kodein.di.generic.bind
import org.kodein.di.generic.instance
import org.kodein.di.generic.singleton


//User default credentials
const val DEFAULT_USER_PASSWORD = "quickblox"

private const val APPLICATION_ID = "88746"
private const val AUTH_KEY = "Qn-3TKyLBWCd-Py"
private const val AUTH_SECRET = "vR8dcXV6jkqF7tt"
private const val ACCOUNT_KEY = "5SntxuqzfTg-AeFSeq8W"

class App : Application(), KodeinAware {

    companion object {
        private lateinit var instance: App

        @Synchronized
        fun getInstance(): App = instance
    }

    override fun onCreate() {
        super.onCreate()
        instance = this
        checkCredentials()
      //  initCredentials()
    }


    private fun checkCredentials() {
        if (APPLICATION_ID.isEmpty() || AUTH_KEY.isEmpty() || AUTH_SECRET.isEmpty() || ACCOUNT_KEY.isEmpty()) {
            throw AssertionError(getString(R.string.error_qb_credentials_empty))
        }
    }
/*

    private fun initCredentials() {
        QBSettings.getInstance().init(applicationContext, APPLICATION_ID, AUTH_KEY, AUTH_SECRET)
        QBSettings.getInstance().accountKey = ACCOUNT_KEY

        // Uncomment and put your Api and Chat servers endpoints if you want to point the sample
        // against your own server.
        //
        // QBSettings.getInstance().setEndpoints("https://your_api_endpoint.com", "your_chat_endpoint", ServiceZone.PRODUCTION);
        // QBSettings.getInstance().zone = ServiceZone.PRODUCTION
    }

*/

    override val kodein = Kodein.lazy {
        import(androidXModule(this@App))
        bind() from singleton { NetworkConnectionInterceptor(instance()) }
        bind() from singleton { MyApi(instance()) }
        bind() from singleton { PreferenceProvider(instance()) }
        bind() from singleton { Repository(instance()) }
        bind() from singleton { LoginViewModelFactory(instance()) }
        bind() from singleton { SettingViewModelFactory(instance()) }
        bind() from singleton { NotificationViewModelFactory(instance()) }
        bind() from singleton { HomeViewModelFactory(instance()) }
        bind() from singleton { ViewQuestionViewModelFactory(instance()) }
    }
}