package com.siguiente.fasal.help.fragment

import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FragmentScheduleMeetingBinding
import com.siguiente.fasal.help.model.ScheduledMeetingModel
import com.siguiente.fasal.home.HomeViewModelFactory
import kotlinx.android.synthetic.main.fragment_schedule_meeting.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class ScheduleMeetingFragment : Fragment(), KodeinAware {
    override val kodein by kodein()
    private val factory: HomeViewModelFactory by instance()
    lateinit var binding: FragmentScheduleMeetingBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding =
            DataBindingUtil.inflate(inflater, R.layout.fragment_schedule_meeting, container, false)


        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        initScheduleMeetingRV()
    }

    fun initScheduleMeetingRV() {
        val arraylist = ArrayList<ScheduledMeetingModel>()
        arraylist.add(ScheduledMeetingModel("", "", "", "", "Krishi Expert"))
        arraylist.add(ScheduledMeetingModel("", "", "", "", "Soil Test"))

        val scheduleAdapter = ScheduledMeetingAdapter().apply {
            addItems(arraylist)
        }
        scheduleMeetingRV.apply {
            adapter = scheduleAdapter
        }
    }

}