package com.siguiente.fasal.databinding;
import com.siguiente.fasal.R;
import com.siguiente.fasal.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class ItemVideoBindingImpl extends ItemVideoBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.playButton, 6);
        sViewsWithIds.put(R.id.videoTimerLayout, 7);
        sViewsWithIds.put(R.id.videoTimer, 8);
        sViewsWithIds.put(R.id.feedProfileIV, 9);
        sViewsWithIds.put(R.id.adminNameTV, 10);
    }
    // views
    @NonNull
    private final com.google.android.material.card.MaterialCardView mboundView0;
    @NonNull
    private final android.widget.TextView mboundView1;
    @NonNull
    private final android.widget.TextView mboundView5;
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public ItemVideoBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 11, sIncludes, sViewsWithIds));
    }
    private ItemVideoBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (android.widget.TextView) bindings[10]
            , (com.siguiente.fasal.custom_view.CirleImageView) bindings[9]
            , (android.widget.FrameLayout) bindings[6]
            , (android.widget.TextView) bindings[4]
            , (android.widget.TextView) bindings[3]
            , (android.widget.ImageView) bindings[2]
            , (android.widget.TextView) bindings[8]
            , (android.widget.FrameLayout) bindings[7]
            );
        this.mboundView0 = (com.google.android.material.card.MaterialCardView) bindings[0];
        this.mboundView0.setTag(null);
        this.mboundView1 = (android.widget.TextView) bindings[1];
        this.mboundView1.setTag(null);
        this.mboundView5 = (android.widget.TextView) bindings[5];
        this.mboundView5.setTag(null);
        this.storiesContentTV.setTag(null);
        this.storiesDateTV.setTag(null);
        this.storiesImageIV.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x2L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.stories == variableId) {
            setStories((com.siguiente.fasal.news.Stories) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setStories(@Nullable com.siguiente.fasal.news.Stories Stories) {
        this.mStories = Stories;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.stories);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String storiesStoryTypeJavaLangStringVideoStoriesImageIVAndroidStringThumbnailUrlStoriesStoryThumbnailStoriesImageIVAndroidStringStoryUrlStoriesUrl = null;
        java.lang.String storiesImageIVAndroidStringStoryUrlStoriesUrl = null;
        java.lang.String storiesStoryDescription = null;
        java.lang.String storiesStoryType = null;
        com.siguiente.fasal.news.Stories stories = mStories;
        java.lang.String storiesStoryTitle = null;
        boolean storiesStoryTypeJavaLangStringVideo = false;
        android.text.Spanned htmlFromHtmlStoriesStoryDescription = null;
        java.lang.String storiesNewsLink = null;
        java.lang.String mboundView5AndroidStringSourceLinkStoriesNewsLink = null;
        java.lang.String storiesUrl = null;
        java.lang.String storiesCreatedAt = null;
        android.text.Spanned htmlFromHtmlMboundView5AndroidStringSourceLinkStoriesNewsLink = null;
        java.lang.String storiesStoryThumbnail = null;
        java.lang.String storiesImageIVAndroidStringThumbnailUrlStoriesStoryThumbnail = null;

        if ((dirtyFlags & 0x3L) != 0) {



                if (stories != null) {
                    // read stories.storyDescription
                    storiesStoryDescription = stories.getStoryDescription();
                    // read stories.storyType
                    storiesStoryType = stories.getStoryType();
                    // read stories.storyTitle
                    storiesStoryTitle = stories.getStoryTitle();
                    // read stories.newsLink
                    storiesNewsLink = stories.getNewsLink();
                    // read stories.created_at
                    storiesCreatedAt = stories.getCreated_at();
                }


                // read Html.fromHtml(stories.storyDescription)
                htmlFromHtmlStoriesStoryDescription = android.text.Html.fromHtml(storiesStoryDescription);
                // read stories.storyType != "Video"
                storiesStoryTypeJavaLangStringVideo = (storiesStoryType) != ("Video");
                // read (@android:string/source_link) + (stories.newsLink)
                mboundView5AndroidStringSourceLinkStoriesNewsLink = (mboundView5.getResources().getString(R.string.source_link)) + (storiesNewsLink);
            if((dirtyFlags & 0x3L) != 0) {
                if(storiesStoryTypeJavaLangStringVideo) {
                        dirtyFlags |= 0x8L;
                }
                else {
                        dirtyFlags |= 0x4L;
                }
            }


                // read Html.fromHtml((@android:string/source_link) + (stories.newsLink))
                htmlFromHtmlMboundView5AndroidStringSourceLinkStoriesNewsLink = android.text.Html.fromHtml(mboundView5AndroidStringSourceLinkStoriesNewsLink);
        }
        // batch finished

        if ((dirtyFlags & 0x4L) != 0) {

                if (stories != null) {
                    // read stories.url
                    storiesUrl = stories.getUrl();
                }


                // read (@android:string/storyUrl) + (stories.url)
                storiesImageIVAndroidStringStoryUrlStoriesUrl = (storiesImageIV.getResources().getString(R.string.storyUrl)) + (storiesUrl);
        }
        if ((dirtyFlags & 0x8L) != 0) {

                if (stories != null) {
                    // read stories.storyThumbnail
                    storiesStoryThumbnail = stories.getStoryThumbnail();
                }


                // read (@android:string/thumbnailUrl) + (stories.storyThumbnail)
                storiesImageIVAndroidStringThumbnailUrlStoriesStoryThumbnail = (storiesImageIV.getResources().getString(R.string.thumbnailUrl)) + (storiesStoryThumbnail);
        }

        if ((dirtyFlags & 0x3L) != 0) {

                // read stories.storyType != "Video" ? (@android:string/thumbnailUrl) + (stories.storyThumbnail) : (@android:string/storyUrl) + (stories.url)
                storiesStoryTypeJavaLangStringVideoStoriesImageIVAndroidStringThumbnailUrlStoriesStoryThumbnailStoriesImageIVAndroidStringStoryUrlStoriesUrl = ((storiesStoryTypeJavaLangStringVideo) ? (storiesImageIVAndroidStringThumbnailUrlStoriesStoryThumbnail) : (storiesImageIVAndroidStringStoryUrlStoriesUrl));
        }
        // batch finished
        if ((dirtyFlags & 0x3L) != 0) {
            // api target 1

            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView1, storiesStoryTitle);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView5, htmlFromHtmlMboundView5AndroidStringSourceLinkStoriesNewsLink);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.storiesContentTV, htmlFromHtmlStoriesStoryDescription);
            com.siguiente.fasal.utils.ViewUtilsKt.bindFormattedDate(this.storiesDateTV, storiesCreatedAt);
            com.siguiente.fasal.utils.ViewUtilsKt.loadImage(this.storiesImageIV, storiesStoryTypeJavaLangStringVideoStoriesImageIVAndroidStringThumbnailUrlStoriesStoryThumbnailStoriesImageIVAndroidStringStoryUrlStoriesUrl);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): stories
        flag 1 (0x2L): null
        flag 2 (0x3L): stories.storyType != "Video" ? (@android:string/thumbnailUrl) + (stories.storyThumbnail) : (@android:string/storyUrl) + (stories.url)
        flag 3 (0x4L): stories.storyType != "Video" ? (@android:string/thumbnailUrl) + (stories.storyThumbnail) : (@android:string/storyUrl) + (stories.url)
    flag mapping end*/
    //end
}