package com.siguiente.fasal.databinding;
import com.siguiente.fasal.R;
import com.siguiente.fasal.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class PaymentHistoryDesignBindingImpl extends PaymentHistoryDesignBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = null;
    }
    // views
    @NonNull
    private final androidx.cardview.widget.CardView mboundView0;
    @NonNull
    private final android.widget.TextView mboundView1;
    @NonNull
    private final android.widget.TextView mboundView2;
    @NonNull
    private final android.widget.TextView mboundView3;
    @NonNull
    private final android.widget.TextView mboundView4;
    @NonNull
    private final android.widget.TextView mboundView5;
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public PaymentHistoryDesignBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 6, sIncludes, sViewsWithIds));
    }
    private PaymentHistoryDesignBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            );
        this.mboundView0 = (androidx.cardview.widget.CardView) bindings[0];
        this.mboundView0.setTag(null);
        this.mboundView1 = (android.widget.TextView) bindings[1];
        this.mboundView1.setTag(null);
        this.mboundView2 = (android.widget.TextView) bindings[2];
        this.mboundView2.setTag(null);
        this.mboundView3 = (android.widget.TextView) bindings[3];
        this.mboundView3.setTag(null);
        this.mboundView4 = (android.widget.TextView) bindings[4];
        this.mboundView4.setTag(null);
        this.mboundView5 = (android.widget.TextView) bindings[5];
        this.mboundView5.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x2L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.paymentModel == variableId) {
            setPaymentModel((com.siguiente.fasal.account.model.PaymentHistoryModel) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setPaymentModel(@Nullable com.siguiente.fasal.account.model.PaymentHistoryModel PaymentModel) {
        this.mPaymentModel = PaymentModel;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.paymentModel);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String paymentModelAmount = null;
        java.lang.String javaLangStringTransactionIDPaymentModelTransactionID = null;
        java.lang.String paymentModelTransactionStatus = null;
        boolean paymentModelTransactionIDJavaLangObjectNull = false;
        java.lang.String javaLangStringStatusPaymentModelTransactionStatus = null;
        java.lang.String paymentModelTransactionIDJavaLangObjectNullJavaLangStringTransactionIDPaymentModelTransactionIDJavaLangString = null;
        java.lang.String paymentModelTransactionID = null;
        java.lang.String paymentModelTransactionIDJavaLangObjectNullJavaLangStringPaidToAdminJavaLangStringReceivedFromAdmin = null;
        com.siguiente.fasal.account.model.PaymentHistoryModel paymentModel = mPaymentModel;
        java.lang.String javaLangStringPaymentModelAmount = null;
        java.lang.String paymentModelCreatedAt = null;

        if ((dirtyFlags & 0x3L) != 0) {



                if (paymentModel != null) {
                    // read paymentModel.amount
                    paymentModelAmount = paymentModel.getAmount();
                    // read paymentModel.transactionStatus
                    paymentModelTransactionStatus = paymentModel.getTransactionStatus();
                    // read paymentModel.transactionID
                    paymentModelTransactionID = paymentModel.getTransactionID();
                    // read paymentModel.created_at
                    paymentModelCreatedAt = paymentModel.getCreated_at();
                }


                // read ("₹ ") + (paymentModel.amount)
                javaLangStringPaymentModelAmount = ("₹ ") + (paymentModelAmount);
                // read ("Status - ") + (paymentModel.transactionStatus)
                javaLangStringStatusPaymentModelTransactionStatus = ("Status - ") + (paymentModelTransactionStatus);
                // read paymentModel.transactionID != null
                paymentModelTransactionIDJavaLangObjectNull = (paymentModelTransactionID) != (null);
            if((dirtyFlags & 0x3L) != 0) {
                if(paymentModelTransactionIDJavaLangObjectNull) {
                        dirtyFlags |= 0x8L;
                        dirtyFlags |= 0x20L;
                }
                else {
                        dirtyFlags |= 0x4L;
                        dirtyFlags |= 0x10L;
                }
            }


                // read paymentModel.transactionID != null ? "Paid to admin" : "Received from admin"
                paymentModelTransactionIDJavaLangObjectNullJavaLangStringPaidToAdminJavaLangStringReceivedFromAdmin = ((paymentModelTransactionIDJavaLangObjectNull) ? ("Paid to admin") : ("Received from admin"));
        }
        // batch finished

        if ((dirtyFlags & 0x8L) != 0) {

                // read ("TransactionID : ") + (paymentModel.transactionID)
                javaLangStringTransactionIDPaymentModelTransactionID = ("TransactionID : ") + (paymentModelTransactionID);
        }

        if ((dirtyFlags & 0x3L) != 0) {

                // read paymentModel.transactionID != null ? ("TransactionID : ") + (paymentModel.transactionID) : ""
                paymentModelTransactionIDJavaLangObjectNullJavaLangStringTransactionIDPaymentModelTransactionIDJavaLangString = ((paymentModelTransactionIDJavaLangObjectNull) ? (javaLangStringTransactionIDPaymentModelTransactionID) : (""));
        }
        // batch finished
        if ((dirtyFlags & 0x3L) != 0) {
            // api target 1

            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView1, paymentModelTransactionIDJavaLangObjectNullJavaLangStringPaidToAdminJavaLangStringReceivedFromAdmin);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView2, javaLangStringPaymentModelAmount);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView3, paymentModelTransactionIDJavaLangObjectNullJavaLangStringTransactionIDPaymentModelTransactionIDJavaLangString);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView4, javaLangStringStatusPaymentModelTransactionStatus);
            com.siguiente.fasal.utils.ViewUtilsKt.bindFormattedDate(this.mboundView5, paymentModelCreatedAt);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): paymentModel
        flag 1 (0x2L): null
        flag 2 (0x3L): paymentModel.transactionID != null ? ("TransactionID : ") + (paymentModel.transactionID) : ""
        flag 3 (0x4L): paymentModel.transactionID != null ? ("TransactionID : ") + (paymentModel.transactionID) : ""
        flag 4 (0x5L): paymentModel.transactionID != null ? "Paid to admin" : "Received from admin"
        flag 5 (0x6L): paymentModel.transactionID != null ? "Paid to admin" : "Received from admin"
    flag mapping end*/
    //end
}