package com.siguiente.fasal.databinding;
import com.siguiente.fasal.R;
import com.siguiente.fasal.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class ShopDesignBindingImpl extends ShopDesignBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.shopItemTV, 3);
    }
    // views
    @NonNull
    private final androidx.cardview.widget.CardView mboundView0;
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public ShopDesignBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 4, sIncludes, sViewsWithIds));
    }
    private ShopDesignBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (android.widget.ImageView) bindings[1]
            , (android.widget.TextView) bindings[2]
            , (android.widget.TextView) bindings[3]
            );
        this.mboundView0 = (androidx.cardview.widget.CardView) bindings[0];
        this.mboundView0.setTag(null);
        this.shopImageIV.setTag(null);
        this.shopItemName.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x2L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.shopModel == variableId) {
            setShopModel((com.siguiente.fasal.home.model.ShopModel) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setShopModel(@Nullable com.siguiente.fasal.home.model.ShopModel ShopModel) {
        this.mShopModel = ShopModel;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.shopModel);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        com.siguiente.fasal.home.model.ShopModel shopModel = mShopModel;
        java.lang.String shopImageIVAndroidStringProfileImageUrlShopModelPhoto = null;
        java.lang.String shopModelPhoto = null;
        java.lang.String shopModelShopName = null;

        if ((dirtyFlags & 0x3L) != 0) {



                if (shopModel != null) {
                    // read shopModel.photo
                    shopModelPhoto = shopModel.getPhoto();
                    // read shopModel.shopName
                    shopModelShopName = shopModel.getShopName();
                }


                // read (@android:string/profileImageUrl) + (shopModel.photo)
                shopImageIVAndroidStringProfileImageUrlShopModelPhoto = (shopImageIV.getResources().getString(R.string.profileImageUrl)) + (shopModelPhoto);
        }
        // batch finished
        if ((dirtyFlags & 0x3L) != 0) {
            // api target 1

            com.siguiente.fasal.utils.ViewUtilsKt.loadImage(this.shopImageIV, shopImageIVAndroidStringProfileImageUrlShopModelPhoto);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.shopItemName, shopModelShopName);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): shopModel
        flag 1 (0x2L): null
    flag mapping end*/
    //end
}