package com.siguiente.fasal.databinding;
import com.siguiente.fasal.R;
import com.siguiente.fasal.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class ShopItemDesignBindingImpl extends ShopItemDesignBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.shopListItemIV, 6);
        sViewsWithIds.put(R.id.shopCallButton, 7);
    }
    // views
    @NonNull
    private final androidx.cardview.widget.CardView mboundView0;
    @NonNull
    private final android.widget.TextView mboundView2;
    @NonNull
    private final android.widget.TextView mboundView3;
    @NonNull
    private final android.widget.TextView mboundView4;
    @NonNull
    private final android.widget.TextView mboundView5;
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public ShopItemDesignBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 8, sIncludes, sViewsWithIds));
    }
    private ShopItemDesignBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (com.google.android.material.button.MaterialButton) bindings[7]
            , (android.widget.ImageView) bindings[1]
            , (android.widget.TextView) bindings[6]
            );
        this.mboundView0 = (androidx.cardview.widget.CardView) bindings[0];
        this.mboundView0.setTag(null);
        this.mboundView2 = (android.widget.TextView) bindings[2];
        this.mboundView2.setTag(null);
        this.mboundView3 = (android.widget.TextView) bindings[3];
        this.mboundView3.setTag(null);
        this.mboundView4 = (android.widget.TextView) bindings[4];
        this.mboundView4.setTag(null);
        this.mboundView5 = (android.widget.TextView) bindings[5];
        this.mboundView5.setTag(null);
        this.shopListImageIV.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x2L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.shopModel == variableId) {
            setShopModel((com.siguiente.fasal.home.model.ShopModel) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setShopModel(@Nullable com.siguiente.fasal.home.model.ShopModel ShopModel) {
        this.mShopModel = ShopModel;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.shopModel);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String javaLangStringMobileNoShopModelUserMobile = null;
        java.lang.String shopListImageIVAndroidStringProfileImageUrlShopModelPhoto = null;
        java.lang.String javaLangStringShopAddressShopModelShopAddress = null;
        java.lang.String shopModelShopName = null;
        java.lang.String shopModelShopType = null;
        com.siguiente.fasal.home.model.ShopModel shopModel = mShopModel;
        java.lang.String shopModelUserMobile = null;
        java.lang.String shopModelPhoto = null;
        java.lang.String shopModelShopAddress = null;
        java.lang.String javaLangStringDealInShopModelShopType = null;

        if ((dirtyFlags & 0x3L) != 0) {



                if (shopModel != null) {
                    // read shopModel.shopName
                    shopModelShopName = shopModel.getShopName();
                    // read shopModel.shopType
                    shopModelShopType = shopModel.getShopType();
                    // read shopModel.userMobile
                    shopModelUserMobile = shopModel.getUserMobile();
                    // read shopModel.photo
                    shopModelPhoto = shopModel.getPhoto();
                    // read shopModel.shopAddress
                    shopModelShopAddress = shopModel.getShopAddress();
                }


                // read ("Deal In - ") + (shopModel.shopType)
                javaLangStringDealInShopModelShopType = ("Deal In - ") + (shopModelShopType);
                // read ("Mobile No - ") + (shopModel.userMobile)
                javaLangStringMobileNoShopModelUserMobile = ("Mobile No - ") + (shopModelUserMobile);
                // read (@android:string/profileImageUrl) + (shopModel.photo)
                shopListImageIVAndroidStringProfileImageUrlShopModelPhoto = (shopListImageIV.getResources().getString(R.string.profileImageUrl)) + (shopModelPhoto);
                // read ("Shop Address - ") + (shopModel.shopAddress)
                javaLangStringShopAddressShopModelShopAddress = ("Shop Address - ") + (shopModelShopAddress);
        }
        // batch finished
        if ((dirtyFlags & 0x3L) != 0) {
            // api target 1

            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView2, shopModelShopName);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView3, javaLangStringMobileNoShopModelUserMobile);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView4, javaLangStringDealInShopModelShopType);
            androidx.databinding.adapters.TextViewBindingAdapter.setText(this.mboundView5, javaLangStringShopAddressShopModelShopAddress);
            com.siguiente.fasal.utils.ViewUtilsKt.loadImage(this.shopListImageIV, shopListImageIVAndroidStringProfileImageUrlShopModelPhoto);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): shopModel
        flag 1 (0x2L): null
    flag mapping end*/
    //end
}