package com.siguiente.fasal

import android.app.AlertDialog
import android.content.Intent
import android.graphics.*
import android.graphics.drawable.ColorDrawable
import android.os.Build
import android.os.Bundle
import android.util.Log
import android.view.Menu
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.Toolbar
import androidx.core.view.GravityCompat
import androidx.drawerlayout.widget.DrawerLayout
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.navigation.NavController
import androidx.navigation.findNavController
import androidx.navigation.ui.*
import com.bumptech.glide.Glide
import com.bumptech.glide.load.engine.DiskCacheStrategy
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.google.android.material.navigation.NavigationView
import com.siguiente.fasal.OnBoarding.OnBoardingActivity
import com.siguiente.fasal.Policies.PoliciesActivity
import com.siguiente.fasal.account.MyAccountActivity
import com.siguiente.fasal.custom_view.CirleImageView
import com.siguiente.fasal.help.SupportActivity
import com.siguiente.fasal.imageCrop.ImageSelectorActivity
import com.siguiente.fasal.information.InformationActivity
import com.siguiente.fasal.kyc.KycDetailsActivity
import com.siguiente.fasal.login.ui.login.LoginActivity
import com.siguiente.fasal.my_store.MyStoreFragment
import com.siguiente.fasal.order.OrderActivity
import com.siguiente.fasal.profile.ChangePasswordActivity
import com.siguiente.fasal.profile.EditProfileActivity
import com.siguiente.fasal.profile.ProfileViewModel
import com.siguiente.fasal.profile.ProfileViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_main.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance


class MainActivity : AppCompatActivity(), KodeinAware {

    lateinit var appBarConfiguration: AppBarConfiguration
    lateinit var navView: BottomNavigationView
    lateinit var navController: NavController
    lateinit var navigationView: NavigationView
    override val kodein by kodein()
    val provider: PreferenceProvider by instance()
    private var userID = String()
    private var activityTag = String()
    private var userType = String()
    private lateinit var viewModel: ProfileViewModel
    val factory: ProfileViewModelFactory by instance()

    @RequiresApi(Build.VERSION_CODES.M)
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        viewModel = ViewModelProvider(this, factory).get(ProfileViewModel::class.java)

        activityTag = intent.extras!!.getString("ActivityTag", "")

        val toolbar: Toolbar = findViewById(R.id.toolbar)
        setSupportActionBar(toolbar)
        supportActionBar!!.setDisplayHomeAsUpEnabled(true)

        navView = findViewById(R.id.bottom_navigation)
        val drawerLayout: DrawerLayout = findViewById(R.id.navigation_layout)
        navigationView = findViewById(R.id.navigation_view)
        navController = findNavController(R.id.nav_host_fragment)

        val view = navigationView.getHeaderView(0)
        val profileImage: CirleImageView = view.findViewById(R.id.circulerProfileIV)
        val profileNameText: TextView = view.findViewById(R.id.profileNameTV)
        val addPhotoAction: ImageView = view.findViewById(R.id.profileAddPhotoButton)
        val mobileText: TextView = view.findViewById(R.id.profileMobileTV)
        val editDetails: TextView = view.findViewById(R.id.profileEditButton)
        val profileLayout: LinearLayout = view.findViewById(R.id.profileLinearLayout)
        val loginLayout: LinearLayout = view.findViewById(R.id.loginLinearLayout)


        if (activityTag != "Skip") {
            profileLayout.visibility = View.VISIBLE
            loginLayout.visibility = View.GONE
            userID = provider.getValueByKey("userID")!!
            userType = provider.getValueByKey("userType")!!
            val map: HashMap<String, String> = HashMap()
            map["userID"] = userID
            map["userType"] = userType
            viewModel.getUserProfile(map)
        } else {
            profileLayout.visibility = View.GONE
            loginLayout.visibility = View.VISIBLE
            val bitmap: Bitmap = createImage(
                100,
                100,
                "?"
            )!!
            profileImage.setImageBitmap(bitmap)

        }

        viewModel.profileData.observe(this, Observer {
            profileNameText.text = "Name : " + it.userName
            mobileText.text = "Mobile : " + it.userMobile
            provider.saveValueByKey("userMobile", "" + it.userMobile)
            provider.saveValueByKey("userState", "" + it.state)
            hideItem()
            if (!it.photo.isNullOrEmpty()) {
                val url = resources.getString(R.string.profileImageUrl) + "${it.photo}"
                Log.e("Url-", "" + url)
                Glide.with(applicationContext)
                    .load(url).diskCacheStrategy(DiskCacheStrategy.NONE)
                    .skipMemoryCache(true).into(profileImage)
            } else if (!it.userName.isNullOrEmpty()) {
                val firstChar = it.userName.substring(0, 1)

                val bitmap: Bitmap = createImage(
                    100,
                    100,
                    firstChar
                )!!
                profileImage.setImageBitmap(bitmap)
            }
        })

        loginLayout.setOnClickListener {
            startActivity(Intent(applicationContext, LoginActivity::class.java))
        }

        addPhotoAction.setOnClickListener {
            startActivity(Intent(this, ImageSelectorActivity::class.java))
        }



        appBarConfiguration = AppBarConfiguration(
            setOf(
                R.id.navigation_home,
                R.id.navigation_news,
                R.id.nav_myAccount,
                R.id.nav_myStore,
                R.id.nav_kyc,
                R.id.nav_helpSupport,
                R.id.nav_information,
                R.id.nav_changePassword,
                R.id.nav_policies,
                R.id.nav_policies
            ), drawerLayout
        )
        setupActionBarWithNavController(navController, appBarConfiguration)
        navigationView.setupWithNavController(navController)
        setupBottomNav(navController)

        navigationView.setNavigationItemSelectedListener { menuItem ->
            when (menuItem.itemId) {
                R.id.nav_myAccount -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, MyAccountActivity::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }
                R.id.nav_myStore -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, MyStoreFragment::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }

                R.id.nav_kyc -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, KycDetailsActivity::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }

                R.id.nav_myOrder -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, OrderActivity::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }


                R.id.nav_helpSupport -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, SupportActivity::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }

                R.id.nav_information -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, InformationActivity::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }

                R.id.nav_changePassword -> {
                    //write your implementation here
                    val intent = Intent(applicationContext, ChangePasswordActivity::class.java)
                    intent.putExtra("ActivityType", "Change")
                    startActivity(intent)
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }

                R.id.nav_policies -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, PoliciesActivity::class.java))
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }
                R.id.nav_logout -> {
                    //write your implementation here
                    startActivity(Intent(applicationContext, OnBoardingActivity::class.java))
                    this.finish()
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    true
                }
                else -> {
                    if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                        drawerLayout.closeDrawer(GravityCompat.START)
                    }
                    false
                }
            }
        }

        editDetails.setOnClickListener {
            startActivity(Intent(this, EditProfileActivity::class.java))
        }

        hideItem()
    }

    private fun setupBottomNav(navigationController: NavController) {

        navView.let { NavigationUI.setupWithNavController(it, navigationController) }

    }

    override fun onSupportNavigateUp(): Boolean {
        val navController = findNavController(R.id.nav_host_fragment)
        return navController.navigateUp(appBarConfiguration) || super.onSupportNavigateUp()
    }

    private fun hideItem() {
        val navMenu: Menu = navigationView.menu
        when (userType) {
            "1" -> {
                navMenu.findItem(R.id.nav_myOrder).isVisible = false
                navMenu.findItem(R.id.nav_myStore).isVisible = true
                navMenu.findItem(R.id.nav_myAccount).isVisible = true
                navMenu.findItem(R.id.nav_kyc).isVisible = true
            }
            "2" -> {
                navMenu.findItem(R.id.nav_myStore).isVisible = false
                navMenu.findItem(R.id.nav_myOrder).isVisible = false
                navMenu.findItem(R.id.nav_myAccount).isVisible = true
                navMenu.findItem(R.id.nav_kyc).isVisible = true
            }
            "3" -> {
                navMenu.findItem(R.id.nav_myOrder).isVisible = true
                navMenu.findItem(R.id.nav_myStore).isVisible = false
                navMenu.findItem(R.id.nav_myAccount).isVisible = false
                navMenu.findItem(R.id.nav_kyc).isVisible = false
            }
            else -> {
                navMenu.findItem(R.id.nav_myOrder).isVisible = false
                navMenu.findItem(R.id.nav_myStore).isVisible = false
                navMenu.findItem(R.id.nav_myAccount).isVisible = false
                navMenu.findItem(R.id.nav_kyc).isVisible = false
            }
        }
    }


    override fun onStart() {
        super.onStart()
        if (activityTag != "Skip") {
            userID = provider.getValueByKey("userID")!!
            userType = provider.getValueByKey("userType")!!
            val map: HashMap<String, String> = HashMap()
            map["userID"] = userID
            map["userType"] = userType
            viewModel.getUserProfile(map)
        }
    }

/*

    @RequiresApi(Build.VERSION_CODES.M)
    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.store_item_add_menu, menu)
        val profileMenuItem: MenuItem = menu!!.findItem(R.id.profileMenu)
        val bitmap: Bitmap = createImage(
            100,
            100,
            resources.getColor(R.color.colorWhite),
            resources.getColor(R.color.colorPrimary),
            "A"
        )!!
        val d: Drawable = BitmapDrawable(resources, bitmap)
        profileMenuItem.setIcon(d)
        return true
    }

*/

    /*  override fun onOptionsItemSelected(item: MenuItem): Boolean {
          return when (item.itemId) {
              R.id.store_category_Add -> {
                  startActivity(Intent(applicationContext, AddProductActivity::class.java))
                  true
              }
              R.id.profileMenu -> {
                  openProfile(supportFragmentManager)
                  true
              }
              else -> super.onOptionsItemSelected(item)

          }
      }*/


    @RequiresApi(Build.VERSION_CODES.M)
    fun createImage(width: Int, height: Int, name: String?): Bitmap? {
        val bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888)
        val canvas = Canvas(bitmap)
        val paint2 = Paint()
        paint2.setColor(resources.getColor(R.color.colorWhite))
        canvas.drawRect(0f, 0f, width.toFloat(), height.toFloat(), paint2)
        val paint = Paint()
        paint.setColor(getColor(R.color.colorPrimary))
        paint.setTextSize(50f)
        //paint.textAlign=Paint.Align.CENTER
        paint.setTextScaleX(1f)
        canvas.drawText(name!!, 50f - 15, 50f + 15, paint)
        //canvas.drawCircle(50f, 50f, 50f, paint)
        return bitmap
    }


    override fun onBackPressed() {
        val alertDialogBuilder = AlertDialog.Builder(
            this@MainActivity
        )
        alertDialogBuilder.setTitle("Confirm")
        alertDialogBuilder.setMessage("Are you sure want to Exit?")
        alertDialogBuilder.setCancelable(false)
        alertDialogBuilder.setPositiveButton(
            "Yes"
        ) { dialog, which ->
            finishAndRemoveTask()
        }.setNegativeButton(
            "No"
        ) { dialog, which -> dialog.dismiss() }
        val alertDialog = alertDialogBuilder.create()
        alertDialog.show()
        alertDialog.window!!.setBackgroundDrawable(ColorDrawable(Color.WHITE))
    }


}
