package com.siguiente.fasal.OnBoarding

import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.View
import androidx.viewpager2.widget.ViewPager2
import com.siguiente.fasal.MainActivity
import com.siguiente.fasal.OnBoarding.adapter.OnBoardingAdapter
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityOnBoardingBinding
import com.siguiente.fasal.login.ui.login.LoginActivity
import com.siguiente.fasal.registration.RegistrationActivity
import com.siguiente.fasal.registration.UserRegistrationActivity
import kotlinx.android.synthetic.main.activity_on_boarding.*

class OnBoardingActivity : AppCompatActivity() {

    private var onBoardingPageChangeCallback = object : ViewPager2.OnPageChangeCallback() {
        override fun onPageSelected(position: Int) {
            updateCircleMarker(binding, position)
        }
    }
    private lateinit var binding: ActivityOnBoardingBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityOnBoardingBinding.inflate(layoutInflater)
        setContentView(binding.root)

        val numberOfScreens = resources.getStringArray(R.array.on_boarding_titles).size
        binding.onBoardingMainContainer.makeStatusBarTransparent()
        val onBoardingAdapter = OnBoardingAdapter(this, numberOfScreens)
        binding.onBoardingViewPager.adapter = onBoardingAdapter
        binding.onBoardingViewPager.registerOnPageChangeCallback(onBoardingPageChangeCallback)

        on_board_sign_up.setOnClickListener{
            val intent = Intent(applicationContext,UserRegistrationActivity::class.java)
            startActivity(intent)
            this.finish()
        }
        on_board_login.setOnClickListener{
            val intent = Intent(applicationContext,LoginActivity::class.java)
            startActivity(intent)
            this.finish()
        }

        on_board_bottom_msg.setOnClickListener {
            val intent = Intent(applicationContext,MainActivity::class.java)
            intent.putExtra("ActivityTag","Skip")
            startActivity(intent)
            this.finish()
        }

    }

    private fun updateCircleMarker(binding: ActivityOnBoardingBinding, position: Int) {
        when (position) {
            0 -> {
                binding.onBoardingInitialCircle.background = getDrawable(R.drawable.bg_green_circle)
                binding.onBoardingMiddleCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingLastCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingLast1Circle.background = getDrawable(R.drawable.bg_gray_circle)
            }
            1 -> {
                binding.onBoardingInitialCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingMiddleCircle.background = getDrawable(R.drawable.bg_green_circle)
                binding.onBoardingLastCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingLast1Circle.background = getDrawable(R.drawable.bg_gray_circle)
            }
            2 -> {
                binding.onBoardingInitialCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingMiddleCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingLastCircle.background = getDrawable(R.drawable.bg_green_circle)
                binding.onBoardingLast1Circle.background = getDrawable(R.drawable.bg_gray_circle)
            }
            3 -> {
                binding.onBoardingInitialCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingMiddleCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingLastCircle.background = getDrawable(R.drawable.bg_gray_circle)
                binding.onBoardingLast1Circle.background = getDrawable(R.drawable.bg_green_circle)
            }
        }
    }

    override fun onDestroy() {
        binding.onBoardingViewPager.unregisterOnPageChangeCallback(onBoardingPageChangeCallback)
        super.onDestroy()
    }

    private fun View.makeStatusBarTransparent() {
        this.systemUiVisibility =
            View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN or View.SYSTEM_UI_FLAG_LAYOUT_STABLE or View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
    }
}