package com.siguiente.fasal

import android.app.Activity
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.razorpay.Checkout
import com.razorpay.PaymentResultListener
import com.siguiente.fasal.databinding.ActivityPayCreditBinding
import com.siguiente.fasal.dialog.TransferCreditViewModel
import com.siguiente.fasal.dialog.TransferCreditViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_pay_credit.*
import kotlinx.android.synthetic.main.fragment_transfer_credit_bottom_sheet.*
import org.json.JSONObject
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class PayCreditActivity : AppCompatActivity(), KodeinAware, PaymentResultListener {
    override val kodein by kodein()
    lateinit var binding: ActivityPayCreditBinding
    private val transferFactory: TransferCreditViewModelFactory by instance()
    val provider: PreferenceProvider by instance()
    private lateinit var transferCreditViewModel: TransferCreditViewModel


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_pay_credit)

        transferCreditViewModel =
            ViewModelProvider(this, transferFactory).get(TransferCreditViewModel::class.java)

        Checkout.preload(applicationContext)

        transferCreditViewModel.result.observe(this, Observer {
            this.finish()
        })

        payCreditBackIV.setOnClickListener {
            provider.saveValueByKey("PayableAmount", payCreditAmount.text.toString().trim())
            onBackPressed()
        }

        payButton.setOnClickListener {
            provider.saveValueByKey("PayableAmount", payCreditAmount.text.toString().trim())
            startPayment(payCreditAmount.text.toString().trim().toInt())
        }
    }

    private fun startPayment(amount: Int) {
        val userMobile = provider.getValueByKey("userMobile")
        val activity: Activity = this
        val co = Checkout()

        try {
            val options = JSONObject()
            options.put("name", "Kishan")
            options.put("description", "Loan Amount")
            options.put("image", "https://s3.amazonaws.com/rzp-mobile/images/rzp.png")
            options.put("currency", "INR")
            options.put("amount", amount * 100)

            val prefill = JSONObject()
            prefill.put("email", "test@razorpay.com")
            prefill.put("contact", userMobile)

            options.put("prefill", prefill)
            co.open(activity, options)
        } catch (e: Exception) {
            Toast.makeText(activity, "Error in payment: " + e.message, Toast.LENGTH_LONG).show()
            e.printStackTrace()
        }
    }

    private fun payCredit(transactionID: String) {
        val userID = provider.getValueByKey("userID")
        val payableAmount = provider.getValueByKey("PayableAmount")
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID!!
        map["amount"] = payableAmount!!
        map["transactionID"] = transactionID
        map["transactionStatus"] = "Success"
        transferCreditViewModel.payCredit(map)
    }

    override fun onPaymentError(errorCode: Int, response: String?) {
        try {
            Toast.makeText(this, "Payment failed $errorCode \n $response", Toast.LENGTH_LONG).show()
        } catch (e: Exception) {
            Log.e("ExceptiononPaymentSuc", "" + e.toString())
        }
    }

    override fun onPaymentSuccess(razorpayPaymentId: String?) {
        try {
            payCredit(razorpayPaymentId!!)
            Toast.makeText(this, "Payment Successful $razorpayPaymentId", Toast.LENGTH_LONG).show()
        } catch (e: Exception) {
            Log.e("ExceptiononPaymentSuc", "" + e.toString())
        }
    }
}