package com.siguiente.fasal.Policies

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.text.Html
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityPoliciesBinding
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_policies.*
import kotlinx.android.synthetic.main.fragment_profile.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class PoliciesActivity : AppCompatActivity(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: ActivityPoliciesBinding
    val provider: PreferenceProvider by instance()
    val factory: PoliciesViewModelFactory by instance()
    lateinit var viewModel: PoliciesViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_policies)
        viewModel = ViewModelProvider(this, factory).get(PoliciesViewModel::class.java)
        viewModel.getPolicies()

        viewModel.result.observe(this, Observer {
            if (!it.error) {
                policiesDescriptionTV.text = Html.fromHtml(it.description)
            }
        })

        policiesBackIV.setOnClickListener {
            onBackPressed()
        }

    }
}