package com.siguiente.fasal.Policies

import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.PoliciesResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException


class PoliciesViewModel(
    var repository: PoliciesRepository
) : ViewModel() {

    var result = MutableLiveData<PoliciesResponse>()

    //For Getting Policies
    fun getPolicies() {
        Coroutines.main {
            try {
                val response = repository.getPolicies()
                result.value = response
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }
}
