package com.siguiente.fasal.account

import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.account.adapter.CashRequestHistoryAdapter
import com.siguiente.fasal.account.model.PaymentHistoryModel
import com.siguiente.fasal.databinding.CashRequestHisFragmentBinding
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.cash_request_his_fragment.*
import kotlinx.android.synthetic.main.payment_his_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class CashRequestHisFragment : Fragment(), KodeinAware {
    val provider: PreferenceProvider by instance()
    override val kodein by kodein()
    var userID = ""
    var userType = ""
    lateinit var binding: CashRequestHisFragmentBinding
    val factory: PaymentHisViewModelFactory by instance()

    companion object {
        fun newInstance() = PaymentHisFragment()
    }

    private lateinit var viewModel: PaymentHisViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.cash_request_his_fragment, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(PaymentHisViewModel::class.java)

        userID = provider.getValueByKey("userID")!!
        userType = provider.getValueByKey("userType")!!
        val map: HashMap<String, String> = HashMap()
        if (userType == "1") {
            map["userID"] = userID
            viewModel.getCashRequestHistory(map)

        }
        viewModel.paymentHistoryResponse.observe(viewLifecycleOwner, Observer {
            if (!it.error) {
                cashRequestRecyclerView.visibility = View.VISIBLE
                noCashRequestDataFoundTV.visibility = View.GONE
                initPaymentHistoryList(it.data)
            }else{
                cashRequestRecyclerView.visibility = View.GONE
                noCashRequestDataFoundTV.visibility = View.VISIBLE
            }
        })
    }

    private fun initPaymentHistoryList(productsItem: ArrayList<PaymentHistoryModel>) {
        val mAdapter = CashRequestHistoryAdapter().apply {
            addItems(productsItem)
        }
        cashRequestRecyclerView.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = mAdapter
        }
    }

}