package com.siguiente.fasal.account

import android.app.Dialog
import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import android.service.autofill.VisibilitySetterAction
import android.util.DisplayMetrics
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import android.widget.Toast
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ForgetPasswordFragmentBinding
import kotlinx.android.synthetic.main.forget_password_fragment.*

class ForgetPassword : BottomSheetDialogFragment() {

    lateinit var binding:ForgetPasswordFragmentBinding
    companion object {
        fun newInstance() = ForgetPassword()
    }

    private lateinit var viewModel: ForgetPasswordViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater,R.layout.forget_password_fragment, container, false)




        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this).get(ForgetPasswordViewModel::class.java)
        // TODO: Use the ViewModel


        forgotBackIV.setOnClickListener {
            dismiss()
        }

        getOtpButton.setOnClickListener{
            getOtpButton.isClickable= false
            forgotPassMobileET.isEnabled = false
            fillOTPLayout.isVisible = true
        }

        resendOtpTV.setOnClickListener {
            Toast.makeText(context, "OTP will send on your mobile number", Toast.LENGTH_SHORT).show()
        }
    }

    override fun onStart() {
        super.onStart()
        val sheetContainer = requireView().parent as? ViewGroup ?: return
        sheetContainer.layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        return BottomSheetDialog(requireContext(), theme).apply {
            behavior.state = BottomSheetBehavior.STATE_EXPANDED
           // behavior.peekHeight =

        }
    }


}