package com.siguiente.fasal.account

import android.app.Activity
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.ImageView
import android.widget.Toast
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.viewpager.widget.ViewPager
import com.google.android.material.tabs.TabLayout
import com.razorpay.Checkout
import com.razorpay.PaymentResultListener
import com.siguiente.fasal.PayCreditActivity
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.ActivityMyAccountBinding
import com.siguiente.fasal.dialog.TransferCreditBottomSheet
import com.siguiente.fasal.dialog.TransferCreditBottomSheet.DialogDismiss
import com.siguiente.fasal.kyc.ui.main.SectionsPagerAdapter
import com.siguiente.fasal.profile.ProfileViewModel
import com.siguiente.fasal.profile.ProfileViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.activity_my_account.*
import org.json.JSONObject
import org.kodein.di.KodeinAware
import org.kodein.di.android.kodein
import org.kodein.di.generic.instance

class MyAccountActivity : AppCompatActivity(), KodeinAware, DialogDismiss {

    lateinit var backAction: ImageView
    var titleOne: String = ""
    var titleTwo: String = ""
    var userID: String = ""
    var userType: String = ""
    val provider: PreferenceProvider by instance()
    override val kodein by kodein()

    private lateinit var viewModel: ProfileViewModel
    private lateinit var viewModelTrans: TransactionHisViewModel
    val factory: ProfileViewModelFactory by instance()
    var availableCredit: Int = 0
    val factoryTrans: TransactionHisViewModelFactory by instance()

    lateinit var binding: ActivityMyAccountBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = DataBindingUtil.setContentView(this, R.layout.activity_my_account)
        supportActionBar?.hide()
        accountProgressBar.visibility = View.VISIBLE



        viewModel = ViewModelProvider(this, factory).get(ProfileViewModel::class.java)
        userID = provider.getValueByKey("userID")!!
        userType = provider.getValueByKey("userType")!!
        getProfile()

        viewModel.profileData.observe(this, Observer {
            binding.profileResponse = it
            availableCredit = it.availableCredit!!.toInt()
            accountProgressBar.visibility = View.GONE
        })

        backAction = findViewById(R.id.myAccountBackIV)

        if (userType == "2") {
            transferCreditButton.text = "Redeem Credit"
            titleOne = "Payment Received"
            titleTwo = "Redeemed History"
            payCreditButton.visibility = View.GONE
            requestForCashButton.visibility = View.GONE
            utilizedCreditTV.visibility = View.GONE
        } else if (userType == "1") {
            transferCreditButton.text = "Transfer Credit"
            titleOne = "Transaction History"
            titleTwo = "Credit Received History"
            utilizedCreditTV.visibility = View.VISIBLE
            payCreditButton.visibility = View.VISIBLE
        }

        setStatePageAdapter()

        backAction.setOnClickListener {
            onBackPressed()
        }

        transferCreditButton.setOnClickListener {
            if (availableCredit > 0) {
                val transferDialog = TransferCreditBottomSheet(transferCreditButton.text.toString(),availableCredit)
                transferDialog.show(supportFragmentManager, "Transfer Credit")
                transferDialog.dismissDialog(this)
            }

        }

        payCreditButton.setOnClickListener {
           startActivity(Intent(this,PayCreditActivity::class.java))
        }

        requestForCashButton.setOnClickListener {
            if (availableCredit > 0) {
                val transferDialog = TransferCreditBottomSheet(requestForCashButton.text.toString(),availableCredit)
                transferDialog.show(supportFragmentManager, "Request For Cash")
                transferDialog.dismissDialog(this)
            }
        }

    }


    private fun getProfile() {
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID
        map["userType"] = userType
        viewModel.getUserProfile(map)
    }

    private fun setStatePageAdapter() {
        val viewPager: ViewPager = findViewById(R.id.view_pagerAccount)
        val tabs: TabLayout = findViewById(R.id.tabsAccount)
        val sectionsPagerAdapter = SectionsPagerAdapter(this, supportFragmentManager)
        if (userType == "1") {
            sectionsPagerAdapter.addFragment(TransactionHisFragment(), titleOne)
            sectionsPagerAdapter.addFragment(PaymentHisFragment(), titleTwo)
            sectionsPagerAdapter.addFragment(CashRequestHisFragment(), "Cash Request")
        }else{
            sectionsPagerAdapter.addFragment(TransactionHisFragment(), titleOne)
            sectionsPagerAdapter.addFragment(PaymentHisFragment(), titleTwo)
        }
        viewPager.adapter = sectionsPagerAdapter
        tabs.setupWithViewPager(viewPager)

    }

    override fun dismiss() {
        getProfile()
        setStatePageAdapter()
    }


}