package com.siguiente.fasal.account

import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.account.adapter.PaymentHistoryAdapter
import com.siguiente.fasal.account.model.PaymentHistoryModel
import com.siguiente.fasal.databinding.PaymentHisFragmentBinding
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.payment_his_fragment.*
import kotlinx.android.synthetic.main.transaction_his_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class PaymentHisFragment : Fragment(), KodeinAware {
    val provider: PreferenceProvider by instance()
    override val kodein by kodein()
    var userID = ""
    var userType = ""
    lateinit var binding: PaymentHisFragmentBinding
    val factory: PaymentHisViewModelFactory by instance()

    companion object {
        fun newInstance() = PaymentHisFragment()
    }

    private lateinit var viewModel: PaymentHisViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = DataBindingUtil.inflate(inflater, R.layout.payment_his_fragment, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(PaymentHisViewModel::class.java)

        paymentRecyclerView.visibility = View.GONE
        noPaymentDataFoundTV.visibility = View.VISIBLE
        userID = provider.getValueByKey("userID")!!
        userType = provider.getValueByKey("userType")!!

        val map: HashMap<String, String> = HashMap()
        if (userType == "1") {
            map["userID"] = userID
            viewModel.getPayCreditHistory(map)

        } else {
            map["venderID"] = userID
            viewModel.getRedeemCreditHistory(map)
        }

        viewModel.paymentHistoryResponse.observe(viewLifecycleOwner, Observer {
            paymentRecyclerView.visibility = View.VISIBLE
            noPaymentDataFoundTV.visibility = View.GONE
            if (!it.error)
                initPaymentHistoryList(it.data)
        })
    }

    private fun initPaymentHistoryList(productsItem: ArrayList<PaymentHistoryModel>) {
        val mAdapter = PaymentHistoryAdapter().apply {
            addItems(productsItem)
        }
        paymentRecyclerView.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = mAdapter
        }
    }

}