package com.siguiente.fasal.account

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.PaymentHistoryResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class PaymentHisViewModel(
    val repository: PaymentHistoryRepository
) : ViewModel() {

    val paymentHistoryResponse = MutableLiveData<PaymentHistoryResponse>()


    fun getPayCreditHistory(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getPayCreditHistory(field)
                Log.e("getPayCreditHistory", "" + response.toString())
                if (!response.error) {
                    paymentHistoryResponse.value = response
                } else {
                    paymentHistoryResponse.value = response

                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun getRedeemCreditHistory(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getRedeemCreditHistory(field)
                Log.e("redeemHistoryResponse", "" + response.toString())
                if (!response.error) {
                    paymentHistoryResponse.value = response
                } else {
                    paymentHistoryResponse.value = response

                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun getCashRequestHistory(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getCashRequestHistory(field)
                Log.e("getCashRequestHistory", "" + response.toString())
                if (!response.error) {
                    paymentHistoryResponse.value = response
                } else {
                    paymentHistoryResponse.value = response

                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}