package com.siguiente.fasal.account

import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.PaymentHistoryResponse

class PaymentHistoryRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun getPayCreditHistory(filed: HashMap<String, String>): PaymentHistoryResponse {
        return apiRequest { api.getPayCreditHistory(filed) }
    }

    suspend fun getRedeemCreditHistory(filed: HashMap<String, String>): PaymentHistoryResponse {
        return apiRequest { api.getRedeemCreditHistory(filed) }
    }
    suspend fun getCashRequestHistory(filed: HashMap<String, String>): PaymentHistoryResponse {
        return apiRequest { api.getCashRequestHistory(filed) }
    }
}