package com.siguiente.fasal.account

import android.content.Context
import androidx.lifecycle.ViewModelProvider
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.recyclerview.widget.LinearLayoutManager
import com.siguiente.fasal.R
import com.siguiente.fasal.account.adapter.TransactionHistoryAdapter
import com.siguiente.fasal.account.model.TransactionHistoryModel
import com.siguiente.fasal.databinding.TransactionHisFragmentBinding
import com.siguiente.fasal.utils.PreferenceProvider
import kotlinx.android.synthetic.main.transaction_his_fragment.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance

class TransactionHisFragment : Fragment(), KodeinAware {
    val provider: PreferenceProvider by instance()
    override val kodein by kodein()
    var userID = ""
    var userType = ""
    lateinit var binding: TransactionHisFragmentBinding
    val factory: TransactionHisViewModelFactory by instance()

    companion object {
        fun newInstance() = TransactionHisFragment()
    }



    private lateinit var viewModel: TransactionHisViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding =
            DataBindingUtil.inflate(inflater, R.layout.transaction_his_fragment, container, false)

        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProvider(this, factory).get(TransactionHisViewModel::class.java)
        transactionRecyclerView.visibility = View.GONE
        noDataFoundTV.visibility = View.VISIBLE

        userID = provider.getValueByKey("userID")!!
        userType = provider.getValueByKey("userType")!!

        val map: HashMap<String, String> = HashMap()
        if (userType == "1") {
            map["userID"] = userID
            viewModel.getTransactionHistory(map)

        } else {
            map["venderID"] = userID
            viewModel.getCreditReceivedHistory(map)
        }

        viewModel.transactionHistoryResponse.observe(viewLifecycleOwner, Observer {
            transactionRecyclerView.visibility = View.VISIBLE
            noDataFoundTV.visibility = View.GONE
            if (!it.error)
                initTransactionHistoryList(it.data)
        })
    }

    private fun initTransactionHistoryList(productsItem: ArrayList<TransactionHistoryModel>) {
        val mAdapter = TransactionHistoryAdapter().apply {
            addItems(productsItem)
        }
        transactionRecyclerView.apply {
            layoutManager = LinearLayoutManager(context)
            setHasFixedSize(true)
            adapter = mAdapter
        }
    }


    override fun onAttach(context: Context) {
        super.onAttach(context)
        Log.e("OnAttach","Call")
    }

    override fun onResume() {
        super.onResume()
        Log.e("OnResume","Call")
    }

    override fun onStart() {
        super.onStart()
        Log.e("OnStart","Call")
    }

    override fun onStop() {
        super.onStop()
        Log.e("OnStop","Call")
    }

}