package com.siguiente.fasal.account

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.SeedGrainsResponse
import com.siguiente.fasal.network.response.TransactionHistoryResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException

class TransactionHisViewModel(val repository: TransactionHistoryRepository
) : ViewModel() {


    val transactionHistoryResponse = MutableLiveData<TransactionHistoryResponse>()


    fun getTransactionHistory(field: Map<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getTransferCreditHistory(field)
                Log.e("getTransferCreditHis", "" + response.toString())
                if (response.error != true) {
                    transactionHistoryResponse.value = response
                } else {
                    transactionHistoryResponse.value = response

                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }


    fun getCreditReceivedHistory(field: HashMap<String, String>) {
        Coroutines.main {
            try {
                val response = repository.getCreditReceivedHistory(field)
                Log.e("getTransferCreditHis", "" + response.toString())
                if (response.error != true) {
                    transactionHistoryResponse.value = response
                } else {
                    transactionHistoryResponse.value = response

                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}