package com.siguiente.fasal.account

import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.TransactionHistoryResponse

class TransactionHistoryRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun getTransferCreditHistory(filed: Map<String, String>): TransactionHistoryResponse {
        return apiRequest { api.getTransferCreditHistory(filed) }
    }

    suspend fun getCreditReceivedHistory(filed: HashMap<String, String>): TransactionHistoryResponse {
        return apiRequest { api.getCreditReceivedHistory(filed) }
    }


}