package com.siguiente.fasal.account.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.account.model.PaymentHistoryModel
import com.siguiente.fasal.databinding.CashRequestHistoryDesignBinding
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class CashRequestHistoryAdapter :
    BaseRecyclerViewAdapter<PaymentHistoryModel, CashRequestHistoryDesignBinding>() {
    override fun getLayout() = R.layout.cash_request_history_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<CashRequestHistoryDesignBinding>,
        position: Int
    ) {
        holder.binding.paymentModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}