package com.siguiente.fasal.account.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.account.model.PaymentHistoryModel
import com.siguiente.fasal.databinding.PaymentHistoryDesignBinding
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class PaymentHistoryAdapter :
    BaseRecyclerViewAdapter<PaymentHistoryModel, PaymentHistoryDesignBinding>() {
    override fun getLayout() = R.layout.payment_history_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<PaymentHistoryDesignBinding>,
        position: Int
    ) {
        holder.binding.paymentModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}