package com.siguiente.fasal.account.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.account.model.RedeemHistoryModel
import com.siguiente.fasal.databinding.RedeemHistoryDesignBinding
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter


class RedeemHistoryAdapter: BaseRecyclerViewAdapter<RedeemHistoryModel, RedeemHistoryDesignBinding>() {
    override fun getLayout() = R.layout.transaction_history_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<RedeemHistoryDesignBinding>,
        position: Int
    ) {
        holder.binding.redeemModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}