package com.siguiente.fasal.account.adapter

import com.siguiente.fasal.R
import com.siguiente.fasal.account.model.TransactionHistoryModel
import com.siguiente.fasal.databinding.TransactionHistoryDesignBinding
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter

class TransactionHistoryAdapter: BaseRecyclerViewAdapter<TransactionHistoryModel, TransactionHistoryDesignBinding>() {
    override fun getLayout() = R.layout.transaction_history_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<TransactionHistoryDesignBinding>,
        position: Int
    ) {
        holder.binding.transactionModel = items[position]
        holder.binding.root.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }

    }

}