package com.siguiente.fasal.dialog


import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.core.widget.doOnTextChanged
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FragmentTransferCreditBottomSheetBinding
import com.siguiente.fasal.registration.UserRegistrationViewModel
import com.siguiente.fasal.registration.UserRegistrationViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.utils.toast
import kotlinx.android.synthetic.main.fragment_transfer_credit_bottom_sheet.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance
import kotlin.jvm.internal.Intrinsics


class TransferCreditBottomSheet(private var title: String, var amount: Int) :
    BottomSheetDialogFragment(),
    KodeinAware {

    lateinit var binding: FragmentTransferCreditBottomSheetBinding
    private lateinit var userRegistrationViewModel: UserRegistrationViewModel
    private lateinit var transferCreditViewModel: TransferCreditViewModel
    override val kodein by kodein()
    private val factory: UserRegistrationViewModelFactory by instance()
    private val transferfactory: TransferCreditViewModelFactory by instance()
    val provider: PreferenceProvider by instance()
    private var venderID = ""
    var listener: DialogDismiss? = null

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding = DataBindingUtil.inflate(
            inflater,
            R.layout.fragment_transfer_credit_bottom_sheet,
            container,
            false
        )

        return binding.root
    }

    fun dismissDialog(listerner: DialogDismiss) {
        this.listener = listerner
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        transferHeadingTV.text = title
        when {
            title.contains("Redeem") -> {
                transferMobileTIL.visibility = View.GONE
            }
            title.contains("Request") -> {
                transferMobileTIL.visibility = View.GONE
            }
            else -> {
                transferMobileTIL.visibility = View.VISIBLE
            }
        }

        userRegistrationViewModel =
            ViewModelProvider(this, factory).get(UserRegistrationViewModel::class.java)

        transferCreditViewModel =
            ViewModelProvider(this, transferfactory).get(TransferCreditViewModel::class.java)


        transferCreditViewModel.sendOTPResult.observe(viewLifecycleOwner, Observer {
            requireContext().toast(it.message!!)
        })

        userRegistrationViewModel.verifyOtpResult.observe(viewLifecycleOwner, Observer {
            if (it.contains("Successfully")) {
                when {
                    title.contains("Redeem") -> {
                        redeemCredit()
                    }
                    title.contains("Cash") -> {
                        requestForCash()
                    }
                    else -> {
                        transferCredit()
                    }
                }
            }
        })

        transferCreditViewModel.verifyResult.observe(viewLifecycleOwner, Observer {
            accountHolderNameTV.text = it.shopName
            venderID = it.venderID
        })


        transferCreditViewModel.result.observe(viewLifecycleOwner, Observer {
            requireContext().toast("" + it)
            this.dismiss()
            listener?.dismiss()
        })

        transferMobileET.doOnTextChanged { text, start, before, count ->
            if (text!!.length == 10) {
                verifyShop()
            }
        }

        transferAmountET.doOnTextChanged { text, start, before, count ->
            val enteredAmount: Int? = text.toString().toIntOrNull()
            if (enteredAmount != null) {
                if (enteredAmount >= amount) {
                    transferAmountET.error = "Insufficient balance in your account"
                }
            }
        }

        transferDoneButton.setOnClickListener {
            if (!transferAmountET.text.isNullOrEmpty() && !transferAmountET.text.isNullOrEmpty()) {
                transferOTPLayout.isVisible = true
                transferDoneButton.isClickable = false
                transferDoneButton.isEnabled = false
                transferDoneButton.setBackgroundColor(resources.getColor(R.color.colorGrayTexts))
                val enteredAmount: Int? = transferAmountET.text.toString().toIntOrNull()
                if (enteredAmount != null) {
                    if (enteredAmount >= amount) {
                        transferAmountET.error = "Insufficient balance in your account"
                    } else {
                        sendOTP()
                    }
                }

            } else {
                accountHolderNameTV.text = getString(R.string.enter_proper_mobile_number)
            }
        }

        otpSubmitButton.setOnClickListener {
            if (!otpEditText.text.isNullOrEmpty())
                verifyOTP()
            else
                otpEditText.error = "Enter OTP"
        }

        transferCreditCloseIV.setOnClickListener {
            this.dismiss()
        }


    }

    private fun sendOTP() {
        val userMobile = provider.getValueByKey("userMobile")
        val map: HashMap<String, String> = HashMap()
        map["userMobile"] = userMobile!!
        transferCreditViewModel.sendOTP(map)
    }

    private fun verifyOTP() {
        val userMobile = provider.getValueByKey("userMobile")
        val otp = binding.otpEditText.text.toString().trim()
        val map: HashMap<String, Any> = HashMap()
        map["userMobile"] = userMobile!!
        map["OTP"] = otp.toInt()
        userRegistrationViewModel.verifyOTP(map)
    }

    private fun verifyShop() {
        val mobile = transferMobileET.text.toString()
        val map: HashMap<String, String> = HashMap()
        map["userMobile"] = mobile

        transferCreditViewModel.verifyShop(map)
    }

    private fun transferCredit() {
        val userID = provider.getValueByKey("userID")
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID!!
        map["venderID"] = venderID
        map["amount"] = transferAmountET.text.toString()
        map["remark"] = transferRemarkET.text.toString()
        transferCreditViewModel.transferCredit(map)
    }

    private fun redeemCredit() {
        val userID = provider.getValueByKey("userID")
        val map: HashMap<String, String> = HashMap()
        map["venderID"] = userID!!
        map["amount"] = transferAmountET.text.toString()
        map["remark"] = transferRemarkET.text.toString()
        transferCreditViewModel.redeemCredit(map)
    }


    private fun requestForCash() {
        val userID = provider.getValueByKey("userID")
        val map: HashMap<String, String> = HashMap()
        map["userID"] = userID!!
        map["amount"] = transferAmountET.text.toString()
        map["remark"] = transferRemarkET.text.toString()
        transferCreditViewModel.requestForCash(map)
    }

    public interface DialogDismiss {
        fun dismiss()
    }

}