package com.siguiente.fasal.dialog

import com.google.gson.Gson
import com.siguiente.fasal.network.MyApi
import com.siguiente.fasal.network.SafeApiRequest
import com.siguiente.fasal.network.response.CommonResponse
import com.siguiente.fasal.network.response.VerifyMobileResponse
import com.siguiente.fasal.network.response.VerifyShopResponse
import org.json.JSONObject


class TransferCreditRepository(
    private val api: MyApi
) : SafeApiRequest() {

    suspend fun transferCredit(field:HashMap<String,String>): CommonResponse {
        return apiRequest { api.transferCredit(field) }
    }

    suspend fun redeemCredit(field:HashMap<String,String>): CommonResponse {
        return apiRequest { api.redeemCredit(field) }
    }

    suspend fun verifyShop(map:HashMap<String,String>): VerifyShopResponse {
        return apiRequest { api.verifyShop(map) }
    }


    suspend fun sendOTP(map:HashMap<String,String>): VerifyMobileResponse {
        return apiRequest { api.sendTransactionOTP(map) }
    }

    suspend fun requestForCash(map:HashMap<String,String>): CommonResponse {
        return apiRequest { api.requestForCash(map) }
    }

    suspend fun payCredit(map:HashMap<String,String>): CommonResponse {
        return apiRequest { api.payCredit(map) }
    }


}