package com.siguiente.fasal.dialog

import android.util.Log
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import com.google.gson.Gson
import com.siguiente.fasal.network.response.VerifyMobileResponse
import com.siguiente.fasal.network.response.VerifyShopResponse
import com.siguiente.fasal.utils.ApiException
import com.siguiente.fasal.utils.Coroutines
import com.siguiente.fasal.utils.NoInternetException
import org.json.JSONObject


class TransferCreditViewModel(
    val repository: TransferCreditRepository
) : ViewModel() {

    var result = MutableLiveData<String>()
    var verifyResult = MutableLiveData<VerifyShopResponse>()
    var sendOTPResult = MutableLiveData<VerifyMobileResponse>()

    fun transferCredit(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.transferCredit(field)
                if (response.error != true) {
                    result.value = response.message!!
                    Log.e("TransferResponse -", "" + response.toString())
                } else {
                    result.value = response.message!!
                    Log.e("TransferResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun redeemCredit(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.redeemCredit(field)
                if (response.error != true) {
                    result.value = response.message!!
                    Log.e("RedeemResponse -", "" + response.toString())
                } else {
                    result.value = response.message!!
                    Log.e("RedeemResponse-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun requestForCash(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.requestForCash(field)
                if (response.error != true) {
                    result.value = response.message!!
                    Log.e("requestForCash -", "" + response.toString())
                } else {
                    result.value = response.message!!
                    Log.e("requestForCash-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun verifyShop(map:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.verifyShop(map)
                if (!response.error) {
                    verifyResult.value = response
                    Log.e("VerifyShop -", "" + response.toString())
                } else {
                    verifyResult.value = response
                    Log.e("VerifyShop-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun sendOTP(map:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.sendOTP(map)
                if (response.error != true) {
                    sendOTPResult.value = response
                    Log.i("sendOTP -", "" + response.toString())
                } else {
                    sendOTPResult.value = response
                    Log.i("sendOTP-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

    fun payCredit(field:HashMap<String,String>){
        Coroutines.main {
            try {
                val response = repository.payCredit(field)
                if (response.error != true) {
                    result.value = response.message!!
                    Log.e("payCredit -", "" + response.toString())
                } else {
                    result.value = response.message!!
                    Log.e("payCredit-", "" + response.toString())
                }
            } catch (e: ApiException) {
                e.printStackTrace()
            } catch (e: NoInternetException) {
                e.printStackTrace()
            }
        }
    }

}