package com.siguiente.fasal.filter

import android.util.Log
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.FilterItemDesignBinding
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter
import com.siguiente.fasal.utils.PreferenceProvider

class FilterItemAdapter(val provider: PreferenceProvider) :
    BaseRecyclerViewAdapter<FilterItemModel, FilterItemDesignBinding>() {
    override fun getLayout() = R.layout.filter_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<FilterItemDesignBinding>,
        position: Int
    ) {
        holder.binding.districtCheckBox.text = items[position].district
        holder.binding.districtCheckBox.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }
        val filterData = provider.getValueByKey("selectedDistrictFilterData")
        if (!filterData.isNullOrEmpty()) {
            val splitArray = filterData.split(",").toTypedArray()
            splitArray.forEach {
                val text = holder.binding.districtCheckBox.text.toString()
                if (text == it.trim()) {
                    holder.binding.districtCheckBox.isChecked = true
                }
            }
        }
    }

}