package com.siguiente.fasal.filter

import android.util.Log
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.SortItemDesignBinding
import com.siguiente.fasal.utils.BaseRecyclerViewAdapter
import com.siguiente.fasal.utils.PreferenceProvider
import okhttp3.internal.Internal.instance
import org.kodein.di.generic.instance

class SortAdapter(val provider: PreferenceProvider) :
    BaseRecyclerViewAdapter<ShopTypeModel, SortItemDesignBinding>() {
    override fun getLayout() = R.layout.sort_item_design

    override fun onBindViewHolder(
        holder: Companion.BaseViewHolder<SortItemDesignBinding>,
        position: Int
    ) {

        holder.binding.shopTypeCheckBox.text = items[position].shopType
        holder.binding.shopTypeCheckBox.setOnClickListener {
            listener?.invoke(it, items[position], position)
        }
        val filterData = provider.getValueByKey("selectedShopFilterData")
        if (!filterData.isNullOrEmpty()) {
            val splitArray = filterData.split(",").toTypedArray()
            splitArray.forEach {
                val text = holder.binding.shopTypeCheckBox.text.toString()
                if (text == it.trim()) {
                    holder.binding.shopTypeCheckBox.isChecked = true
                }
            }
        }
    }

}