package com.siguiente.fasal.filter

import android.content.DialogInterface
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.CheckBox
import android.widget.Toast
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.siguiente.fasal.R
import com.siguiente.fasal.databinding.SortAndFilterLayoutBinding
import com.siguiente.fasal.dialog.TransferCreditBottomSheet
import com.siguiente.fasal.help.QuestionActivity
import com.siguiente.fasal.my_store.AddProductActivity
import com.siguiente.fasal.registration.UserRegistrationViewModel
import com.siguiente.fasal.registration.UserRegistrationViewModelFactory
import com.siguiente.fasal.utils.PreferenceProvider
import com.siguiente.fasal.videos.VideoChatViewActivity
import kotlinx.android.synthetic.main.activity_registration.*
import kotlinx.android.synthetic.main.sort_and_filter_layout.*
import org.kodein.di.KodeinAware
import org.kodein.di.android.x.kodein
import org.kodein.di.generic.instance
import java.util.*
import kotlin.collections.ArrayList


class SortAndFilterBottomsheet() : BottomSheetDialogFragment(), KodeinAware {
    override val kodein by kodein()
    lateinit var binding: SortAndFilterLayoutBinding
    private lateinit var viewModel: UserRegistrationViewModel
    private val factory: UserRegistrationViewModelFactory by instance()
    val provider: PreferenceProvider by instance()
    private val filteredShopArray = LinkedList<String>()
    private val filteredDistrictArray = LinkedList<String>()
    var listener: FilterDialogDismiss? = null

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        binding = DataBindingUtil.inflate(
            inflater,
            R.layout.sort_and_filter_layout,
            container,
            false
        )
        return binding.root
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        viewModel = ViewModelProvider(this, factory).get(
            UserRegistrationViewModel::class.java
        )
        getShopTypeList()
        initFilterOption()

        filterCloseIV.setOnClickListener {
            saveFilteredData()
            dismiss()
        }

        viewModel.shopTypeResult.observe(viewLifecycleOwner, Observer { it ->
            if (!it.error) {
                initShopType(it.data)
            }
        })

        viewModel.districtResult.observe(viewLifecycleOwner, Observer { it ->
            if (!it.error) {
                initFilterItem(it.data)
            }
        })

        filterApplyButton.setOnClickListener {
            listener!!.dismiss()
            saveFilteredData()
            dismiss()
        }

        filterClearAllTV.setOnClickListener {
            clearFilterData()
        }


        val filterShopData = provider.getValueByKey("selectedShopFilterData") as String
        if (filterShopData.isNotEmpty()) {
            val splitArray = filterShopData.split(",").toTypedArray()
            splitArray.forEach {
                filteredShopArray.add(it.trim())
            }
        }

        val filterDistrictData = provider.getValueByKey("selectedDistrictFilterData") as String
        if (filterDistrictData.isNotEmpty()) {
            val splitArray = filterDistrictData.split(",").toTypedArray()
            splitArray.forEach {
                filteredDistrictArray.add(it.trim())
            }
        }

    }

    fun dismissDialog(listerner: FilterDialogDismiss) {
        this.listener = listerner
    }

    private fun getShopTypeList() {
        viewModel.getShopTypeList()
    }

    private fun getDistrictList() {
        val state = provider.getValueByKey("userState")
        val map: HashMap<String, String> = HashMap()
        map["state"] = state.toString()
        viewModel.getDistrictList(map)
    }

    private fun initFilterOption() {
        val filterOptionArray = ArrayList<FilterOptionModel>()
        filterOptionArray.add(FilterOptionModel(1, "Shop Type"))
        filterOptionArray.add(FilterOptionModel(2, "District"))


        val filterOptionAdapter = FilterOptionAdapter().apply {
            addItems(filterOptionArray)
        }
        filterOptionRV.apply {
            adapter = filterOptionAdapter
        }

        filterOptionAdapter.listener = { view, item, position ->
            saveFilteredData()
            if (item.filterOptionName.equals("Shop Type")) {
                getShopTypeList()
            } else {
                getDistrictList()
            }
        }

    }

    private fun initShopType(shopTypeArray: ArrayList<ShopTypeModel>) {
        val sortAdapter = SortAdapter(provider).apply {
            addItems(shopTypeArray)
        }
        filterItemRV.isNestedScrollingEnabled = true
        filterItemRV.apply {
            adapter = sortAdapter
        }

        sortAdapter.listener = { view, item, position ->
            val checkBox = view as CheckBox
            if (checkBox.isChecked) {
                filteredShopArray.add(checkBox.text.toString().trim())
            } else {
                filteredShopArray.remove(checkBox.text.toString().trim())
            }
            saveFilteredData()
            getShopTypeList()
        }

    }


    private fun initFilterItem(arrayList: ArrayList<FilterItemModel>) {
        val filterItemAdapter = FilterItemAdapter(provider).apply {
            addItems(arrayList)
        }
        filterItemRV.isNestedScrollingEnabled = true
        filterItemRV.apply {
            adapter = filterItemAdapter
        }

        filterItemAdapter.listener = { view, item, position ->
            val checkBox = view as CheckBox
            if (checkBox.isChecked) {
                filteredDistrictArray.add(checkBox.text.toString().trim())
            } else {
                filteredDistrictArray.remove(checkBox.text.toString().trim())
            }
            saveFilteredData()
        }

    }

    override fun onDismiss(dialog: DialogInterface) {
        saveFilteredData()
        super.onDismiss(dialog)
    }

    private fun saveFilteredData() {
        if (!filteredShopArray.isEmpty()) {
            val shopFilterArray =
                filteredShopArray.toString().replace("[", "").replace("]", "").trim()
            provider.saveValueByKey("selectedShopFilterData", "" + shopFilterArray)
        }
        if (!filteredDistrictArray.isEmpty()) {
            val districtFilterArray =
                filteredDistrictArray.toString().replace("[", "").replace("]", "").trim()
            provider.saveValueByKey("selectedDistrictFilterData", "" + districtFilterArray)
        }

    }

    private fun clearFilterData() {
        filteredShopArray.clear()
        filteredDistrictArray.clear()
        provider.saveValueByKey("selectedShopFilterData", "")
        provider.saveValueByKey("selectedDistrictFilterData", "")
        getShopTypeList()
    }

    public interface FilterDialogDismiss {
        fun dismiss()
    }
}